package hello;

import javax.persistence.*;

@Entity
@Table(name = "PERSON")
@NamedQueries({
    @NamedQuery(name="Person.search",
                query="select p from Person p where p.firstName like :search or p.lastName like :search"),
    @NamedQuery(name="Person.getAll",
                query="select p from Person p order by p.lastName, p.firstName asc")

})
public class Person {

    @Id @GeneratedValue
    @Column(name = "ID")
    private Long id;

    @Column(name = "FIRST_NAME")
    private String firstName;

    @Column(name = "LAST_NAME")
    private String lastName;

    Person() {}

    public Person(String firstName, String lastName) {
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public Long getId() {
        return id;
    }
    private void setId(Long id) {
        this.id = id;
    }

    public String getFirstName() {
        return this.firstName;
    }
    public void setFirstName(String text) {
        this.firstName = text;
    }
    
    public String getLastName() {
        return this.lastName;
    }
    public void setLastName(String text) {
        this.lastName = text;
    }
}
