/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.adapter.RuleTriggerAdapter;
import org.jboss.byteman.agent.adapter.RuleTriggerMethodAdapter;
import org.jboss.byteman.org.objectweb.asm.ClassVisitor;
import org.jboss.byteman.org.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.type.TypeHelper;

public class AccessTriggerAdapter
extends RuleTriggerAdapter {
    private String ownerClass;
    private String fieldName;
    private int flags;
    private int count;
    private boolean whenComplete;
    private int visitedCount;

    public AccessTriggerAdapter(ClassVisitor cv, TransformContext transformContext, String ownerClass, String fieldName, int flags, int count, boolean whenComplete) {
        super(cv, transformContext);
        this.ownerClass = ownerClass;
        this.fieldName = fieldName;
        this.flags = flags;
        this.count = count;
        this.whenComplete = whenComplete;
        this.visitedCount = 0;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.matchTargetMethod(name, desc)) {
            if (name.equals("<init>")) {
                return new AccessTriggerConstructorAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
            }
            return new AccessTriggerMethodAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
        }
        return mv;
    }

    private class AccessTriggerConstructorAdapter
    extends AccessTriggerMethodAdapter {
        AccessTriggerConstructorAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor, signature, exceptions);
            this.latched = true;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            super.visitMethodInsn(opcode, owner, name, desc);
            if (this.latched && opcode == 183) {
                this.latched = false;
            }
        }
    }

    private class AccessTriggerMethodAdapter
    extends RuleTriggerMethodAdapter {
        protected boolean latched;

        AccessTriggerMethodAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor, signature, exceptions);
            AccessTriggerAdapter.this.visitedCount = 0;
            this.latched = false;
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (AccessTriggerAdapter.this.whenComplete) {
                super.visitFieldInsn(opcode, owner, name, desc);
            }
            if ((AccessTriggerAdapter.this.count == 0 || AccessTriggerAdapter.this.visitedCount < AccessTriggerAdapter.this.count) && this.matchCall(opcode, owner, name, desc)) {
                AccessTriggerAdapter.this.visitedCount++;
                if (!(this.latched || AccessTriggerAdapter.this.count != 0 && AccessTriggerAdapter.this.visitedCount != AccessTriggerAdapter.this.count)) {
                    this.injectTriggerPoint();
                }
            }
            if (!AccessTriggerAdapter.this.whenComplete) {
                super.visitFieldInsn(opcode, owner, name, desc);
            }
        }

        private boolean matchCall(int opcode, String owner, String name, String desc) {
            if (!AccessTriggerAdapter.this.fieldName.equals(name)) {
                return false;
            }
            switch (opcode) {
                case 178: 
                case 180: {
                    if ((AccessTriggerAdapter.this.flags & 1) != 0) break;
                    return false;
                }
                case 179: 
                case 181: {
                    if ((AccessTriggerAdapter.this.flags & 2) != 0) break;
                    return false;
                }
            }
            if (AccessTriggerAdapter.this.ownerClass != null && !AccessTriggerAdapter.this.ownerClass.equals(TypeHelper.internalizeClass(owner))) {
                if (AccessTriggerAdapter.this.ownerClass.indexOf(46) >= 0) {
                    return false;
                }
                int ownerPackageIdx = owner.lastIndexOf(47);
                if (ownerPackageIdx < 0) {
                    return false;
                }
                if (!owner.substring(ownerPackageIdx + 1).equals(AccessTriggerAdapter.this.ownerClass)) {
                    return false;
                }
            }
            return true;
        }
    }
}

