/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import java.util.Vector;
import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.adapter.RuleCheckAdapter;
import org.jboss.byteman.agent.adapter.RuleCheckMethodAdapter;
import org.jboss.byteman.org.objectweb.asm.ClassVisitor;
import org.jboss.byteman.org.objectweb.asm.Label;
import org.jboss.byteman.org.objectweb.asm.MethodVisitor;

public class ExitCheckAdapter
extends RuleCheckAdapter {
    private Vector<Label> earlyReturnHandlers = new Vector();

    public ExitCheckAdapter(ClassVisitor cv, TransformContext transformContext) {
        super(cv, transformContext);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ((access & 0x1500) == 0 && this.matchTargetMethod(name, desc)) {
            this.setVisited();
            return new ExitCheckMethodAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
        }
        return mv;
    }

    private class ExitCheckMethodAdapter
    extends RuleCheckMethodAdapter {
        private int access;
        private String name;
        private String descriptor;
        private String signature;
        private String[] exceptions;
        private Vector<Label> startLabels;
        private Vector<Label> endLabels;
        private boolean inhibit;

        ExitCheckMethodAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor);
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
            this.signature = signature;
            this.exceptions = exceptions;
            this.startLabels = new Vector();
            this.endLabels = new Vector();
        }

        @Override
        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            if (type != null && type.equals("org/jboss/byteman/rule/exception/EarlyReturnException")) {
                ExitCheckAdapter.this.earlyReturnHandlers.add(handler);
            }
            super.visitTryCatchBlock(start, end, handler, type);
        }

        @Override
        public void visitLabel(Label label) {
            this.inhibit = ExitCheckAdapter.this.earlyReturnHandlers.contains(label);
            super.visitLabel(label);
        }

        @Override
        public void visitInsn(int opcode) {
            switch (opcode) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    if (this.inhibit) break;
                    this.setTriggerPoint();
                }
            }
            super.visitInsn(opcode);
        }

        @Override
        public void visitEnd() {
            if (this.checkBindings()) {
                ExitCheckAdapter.this.setVisitOk();
            }
            super.visitEnd();
        }
    }
}

