/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.adapter.RuleCheckAdapter;
import org.jboss.byteman.agent.adapter.RuleCheckMethodAdapter;
import org.jboss.byteman.org.objectweb.asm.ClassVisitor;
import org.jboss.byteman.org.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.type.TypeHelper;

public class InvokeCheckAdapter
extends RuleCheckAdapter {
    private String calledClass;
    private String calledMethodName;
    private String calledMethodDescriptor;
    private int count;
    private int visitedCount;

    public InvokeCheckAdapter(ClassVisitor cv, TransformContext transformContext, String calledClass, String calledMethodName, String calledMethodDescriptor, int count) {
        super(cv, transformContext);
        this.calledClass = calledClass;
        this.calledMethodName = calledMethodName;
        this.calledMethodDescriptor = calledMethodDescriptor;
        this.count = count;
        this.visitedCount = 0;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ((access & 0x1500) == 0 && this.matchTargetMethod(name, desc)) {
            this.setVisited();
            return new InvokeCheckMethodAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
        }
        return mv;
    }

    private class InvokeCheckMethodAdapter
    extends RuleCheckMethodAdapter {
        private int access;
        private String name;
        private String descriptor;
        private String signature;
        private String[] exceptions;
        private boolean visited;

        InvokeCheckMethodAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor);
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
            this.signature = signature;
            this.exceptions = exceptions;
            InvokeCheckAdapter.this.visitedCount = 0;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if ((InvokeCheckAdapter.this.count == 0 || InvokeCheckAdapter.this.visitedCount < InvokeCheckAdapter.this.count) && this.matchCall(owner, name, desc)) {
                InvokeCheckAdapter.this.visitedCount++;
                if (InvokeCheckAdapter.this.count == 0 || InvokeCheckAdapter.this.visitedCount == InvokeCheckAdapter.this.count) {
                    this.setTriggerPoint();
                }
            }
            super.visitMethodInsn(opcode, owner, name, desc);
        }

        @Override
        public void visitEnd() {
            if (this.checkBindings()) {
                InvokeCheckAdapter.this.setVisitOk();
            }
            super.visitEnd();
        }

        private boolean matchCall(String owner, String name, String desc) {
            if (!InvokeCheckAdapter.this.calledMethodName.equals(name)) {
                return false;
            }
            if (InvokeCheckAdapter.this.calledClass != null && !InvokeCheckAdapter.this.calledClass.equals(TypeHelper.internalizeClass(owner))) {
                if (InvokeCheckAdapter.this.calledClass.indexOf(46) >= 0) {
                    return false;
                }
                int ownerPackageIdx = owner.lastIndexOf(47);
                if (ownerPackageIdx < 0) {
                    return false;
                }
                if (!owner.substring(ownerPackageIdx + 1).equals(InvokeCheckAdapter.this.calledClass)) {
                    return false;
                }
            }
            return InvokeCheckAdapter.this.calledMethodDescriptor.length() <= 0 || TypeHelper.equalDescriptors(InvokeCheckAdapter.this.calledMethodDescriptor, desc);
        }
    }
}

