/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.adapter.RuleTriggerAdapter;
import org.jboss.byteman.agent.adapter.RuleTriggerMethodAdapter;
import org.jboss.byteman.org.objectweb.asm.ClassVisitor;
import org.jboss.byteman.org.objectweb.asm.MethodVisitor;
import org.jboss.byteman.org.objectweb.asm.Type;
import org.jboss.byteman.rule.type.TypeHelper;

public class InvokeTriggerAdapter
extends RuleTriggerAdapter {
    private String calledClass;
    private String calledMethodName;
    private String calledMethodDescriptor;
    private String matchedClass;
    private String matchedMethodName;
    private String matchedMethodDescriptor;
    private int count;
    private boolean whenComplete;
    private int visitedCount;

    public InvokeTriggerAdapter(ClassVisitor cv, TransformContext transformContext, String calledClass, String calledMethodName, String calledMethodDescriptor, int count, boolean whenComplete) {
        super(cv, transformContext);
        this.calledClass = calledClass;
        this.calledMethodName = calledMethodName;
        this.calledMethodDescriptor = calledMethodDescriptor;
        this.count = count;
        this.whenComplete = whenComplete;
        this.visitedCount = 0;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.matchTargetMethod(name, desc)) {
            if (name.equals("<init>")) {
                return new InvokeTriggerConstructorAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
            }
            return new InvokeTriggerMethodAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
        }
        return mv;
    }

    private class InvokeTriggerConstructorAdapter
    extends InvokeTriggerMethodAdapter {
        InvokeTriggerConstructorAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor, signature, exceptions);
            this.latched = true;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            super.visitMethodInsn(opcode, owner, name, desc);
            if (this.latched && opcode == 183) {
                this.latched = false;
            }
        }
    }

    private class InvokeTriggerMethodAdapter
    extends RuleTriggerMethodAdapter {
        protected boolean latched;

        InvokeTriggerMethodAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor, signature, exceptions);
            InvokeTriggerAdapter.this.visitedCount = 0;
            this.latched = false;
        }

        @Override
        public Type[] getInvokedTypes() {
            Type ownerType = InvokeTriggerAdapter.this.matchedClass != null ? Type.getType(TypeHelper.externalizeType(InvokeTriggerAdapter.this.matchedClass)) : null;
            Type[] argTypes = Type.getArgumentTypes(InvokeTriggerAdapter.this.matchedMethodDescriptor);
            Type returnType = Type.getReturnType(InvokeTriggerAdapter.this.matchedMethodDescriptor);
            int numArgs = argTypes.length;
            Type[] result = new Type[numArgs + 2];
            result[0] = ownerType;
            for (int i = 0; i < numArgs; ++i) {
                result[i + 1] = argTypes[i];
            }
            result[numArgs + 1] = returnType;
            return result;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (InvokeTriggerAdapter.this.whenComplete) {
                super.visitMethodInsn(opcode, owner, name, desc);
            }
            if ((InvokeTriggerAdapter.this.count == 0 || InvokeTriggerAdapter.this.visitedCount < InvokeTriggerAdapter.this.count) && this.matchCall(owner, name, desc)) {
                InvokeTriggerAdapter.this.visitedCount++;
                if (!(this.latched || InvokeTriggerAdapter.this.count != 0 && InvokeTriggerAdapter.this.visitedCount != InvokeTriggerAdapter.this.count)) {
                    this.injectTriggerPoint();
                }
            }
            if (!InvokeTriggerAdapter.this.whenComplete) {
                super.visitMethodInsn(opcode, owner, name, desc);
            }
        }

        private boolean matchCall(String owner, String name, String desc) {
            if (!InvokeTriggerAdapter.this.calledMethodName.equals(name)) {
                return false;
            }
            if (InvokeTriggerAdapter.this.calledClass != null && !InvokeTriggerAdapter.this.calledClass.equals(TypeHelper.internalizeClass(owner))) {
                if (InvokeTriggerAdapter.this.calledClass.indexOf(46) >= 0) {
                    return false;
                }
                int ownerPackageIdx = owner.lastIndexOf(47);
                if (ownerPackageIdx < 0) {
                    return false;
                }
                if (!owner.substring(ownerPackageIdx + 1).equals(InvokeTriggerAdapter.this.calledClass)) {
                    return false;
                }
            }
            if (InvokeTriggerAdapter.this.calledMethodDescriptor.length() > 0 && !TypeHelper.equalDescriptors(InvokeTriggerAdapter.this.calledMethodDescriptor, desc)) {
                return false;
            }
            InvokeTriggerAdapter.this.matchedClass = TypeHelper.internalizeClass(owner);
            InvokeTriggerAdapter.this.matchedMethodName = name;
            InvokeTriggerAdapter.this.matchedMethodDescriptor = desc;
            return true;
        }
    }
}

