/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.adapter.RuleTriggerAdapter;
import org.jboss.byteman.agent.adapter.RuleTriggerMethodAdapter;
import org.jboss.byteman.org.objectweb.asm.ClassVisitor;
import org.jboss.byteman.org.objectweb.asm.Label;
import org.jboss.byteman.org.objectweb.asm.MethodVisitor;

public class LineTriggerAdapter
extends RuleTriggerAdapter {
    private int targetLine;
    private boolean visitedLine;

    public LineTriggerAdapter(ClassVisitor cv, TransformContext transformContext, int targetLine) {
        super(cv, transformContext);
        this.targetLine = targetLine;
        this.visitedLine = false;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.matchTargetMethod(name, desc)) {
            if (name.equals("<init>")) {
                return new LineTriggerConstructorAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
            }
            return new LineTriggerMethodAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
        }
        return mv;
    }

    private class LineTriggerConstructorAdapter
    extends LineTriggerMethodAdapter {
        LineTriggerConstructorAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor, signature, exceptions);
            this.unlatched = false;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            super.visitMethodInsn(opcode, owner, name, desc);
            this.unlatched |= opcode == 183;
        }
    }

    private class LineTriggerMethodAdapter
    extends RuleTriggerMethodAdapter {
        protected boolean unlatched;

        LineTriggerMethodAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor, signature, exceptions);
            this.unlatched = true;
        }

        @Override
        public void visitLineNumber(int line, Label start) {
            if (this.unlatched && !LineTriggerAdapter.this.visitedLine && LineTriggerAdapter.this.targetLine <= line) {
                this.injectTriggerPoint();
            }
            super.visitLineNumber(line, start);
        }
    }
}

