/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.byteman.agent.LocationType;
import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.Transformer;
import org.jboss.byteman.agent.adapter.RuleMethodAdapter;
import org.jboss.byteman.org.objectweb.asm.Label;
import org.jboss.byteman.org.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.binding.Binding;
import org.jboss.byteman.rule.binding.Bindings;
import org.jboss.byteman.rule.type.Type;

public class RuleCheckMethodAdapter
extends RuleMethodAdapter {
    private List<Label> triggerPoints = null;

    RuleCheckMethodAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor) {
        super(mv, transformContext, access, name, descriptor);
    }

    protected void setTriggerPoint() {
        if (this.triggerPoints == null) {
            this.triggerPoints = new ArrayList<Label>();
        }
        Label triggerLabel = new Label();
        this.triggerPoints.add(triggerLabel);
        this.visitLabel(triggerLabel);
    }

    boolean isTriggerPoint() {
        return this.triggerPoints != null;
    }

    protected boolean checkBindings() {
        if (!this.isTriggerPoint()) {
            return false;
        }
        Bindings bindings = this.rule.getBindings();
        Iterator<Binding> bindingIter = bindings.iterator();
        List<String> parameterTypenames = Type.parseMethodDescriptor(this.descriptor, true);
        int parameterCount = parameterTypenames.size() - 1;
        while (bindingIter.hasNext()) {
            Binding binding = bindingIter.next();
            if (binding.isRecipient()) {
                if ((this.access & 8) == 0) continue;
                if (Transformer.isVerbose()) {
                    System.out.println("RuleCheckMethodAdapter.checkBindings : found invalid recipient binding " + binding + " checking static method " + this.name + this.descriptor);
                }
                return false;
            }
            if (binding.isParam()) {
                int idx = binding.getIndex();
                if (idx > parameterCount) {
                    if (Transformer.isVerbose()) {
                        System.out.println("RuleCheckMethodAdapter.checkBindings : found out of range parameter binding " + binding + " checking method " + this.name + this.descriptor);
                    }
                    return false;
                }
                binding.setDescriptor(parameterTypenames.get(idx - 1));
                continue;
            }
            if (binding.isReturn()) {
                if (this.rule.getTargetLocation().getLocationType() == LocationType.EXIT) continue;
                System.out.println("RuleCheckMethodAdapter.checkBindings : found return value binding $! in non-EXIT rule " + this.rule.getName());
                return false;
            }
            if (binding.isThrowable()) {
                if (this.rule.getTargetLocation().getLocationType() == LocationType.THROW) continue;
                System.out.println("RuleCheckMethodAdapter.checkBindings : found throwable value binding $^ in non-THROW rule " + this.rule.getName());
                return false;
            }
            if (binding.isParamArray() || binding.isParamCount()) continue;
            if (binding.isInvokeParamArray()) {
                if (this.rule.getTargetLocation().getLocationType() == LocationType.INVOKE) continue;
                System.out.println("RuleCheckMethodAdapter.checkBindings : found invoke parameter array binding $@ in non-AT INVOKE rule " + this.rule.getName());
                return false;
            }
            if (!binding.isLocalVar()) continue;
            String localVarName = binding.getName().substring(1);
            List<RuleMethodAdapter.LocalVar> localVars = this.lookup(localVarName);
            if (localVars == null || localVars.isEmpty()) {
                if (Transformer.isVerbose()) {
                    System.out.println("RuleCheckMethodAdapter.checkBindings : unknown local variable binding " + binding + " checking method " + this.name + this.descriptor);
                }
                return false;
            }
            String descriptor = null;
            int index = -1;
            Iterator<Label> labelIter = this.triggerPoints.iterator();
            while (labelIter.hasNext()) {
                int triggerPos = labelIter.next().getOffset();
                boolean found = false;
                for (RuleMethodAdapter.LocalVar localVar : localVars) {
                    int start = localVar.start.getOffset();
                    int end = localVar.end.getOffset();
                    if (start > triggerPos || triggerPos >= end) continue;
                    if (descriptor == null && index == -1) {
                        descriptor = localVar.desc;
                        index = localVar.index;
                        found = true;
                        break;
                    }
                    if (!descriptor.equals(localVar.desc) || index != localVar.index) break;
                    found = true;
                    break;
                }
                if (found) continue;
                if (Transformer.isVerbose()) {
                    System.out.println("RuleCheckMethodAdapter.checkBindings : invalid local variable binding " + binding + " checking method " + this.name + descriptor);
                }
                return false;
            }
            binding.setDescriptor(Type.parseFieldDescriptor(descriptor));
            binding.setLocalIndex(index);
        }
        return true;
    }
}

