/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.byteman.java_cup.runtime.Symbol;
import org.jboss.byteman.org.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.RuleElement;
import org.jboss.byteman.rule.binding.Binding;
import org.jboss.byteman.rule.binding.Bindings;
import org.jboss.byteman.rule.compiler.StackHeights;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.ParseException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.expression.ExpressionHelper;
import org.jboss.byteman.rule.grammar.ECAGrammarParser;
import org.jboss.byteman.rule.grammar.ECATokenLexer;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class Event
extends RuleElement {
    public static Event create(Rule rule, ParseNode eventTree) throws TypeException {
        Event event = new Event(rule, eventTree);
        return event;
    }

    public static Event create(Rule rule, String text) throws ParseException, TypeException {
        if ("".equals(text)) {
            return new Event(rule);
        }
        String fullText = "BIND\n" + text + "\nIF TRUE DO NOTHING";
        try {
            ECATokenLexer lexer = new ECATokenLexer(new StringReader(fullText));
            ECAGrammarParser parser = new ECAGrammarParser(lexer);
            Symbol event_parse = parser.parse();
            ParseNode eventTree = (ParseNode)event_parse.value;
            Event event = new Event(rule, eventTree);
            return event;
        }
        catch (Exception e) {
            throw new ParseException("org.jboss.byteman.rule.Event : error parsing event\n" + text, e);
        }
    }

    protected Event(Rule rule, ParseNode eventTree) throws TypeException {
        super(rule);
        this.createBindings(eventTree);
    }

    protected Event(Rule rule) {
        super(rule);
    }

    @Override
    public Bindings getBindings() {
        return this.rule.getBindings();
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        Iterator<Binding> iterator = this.getBindings().iterator();
        while (iterator.hasNext()) {
            Binding binding = iterator.next();
            this.typeCheck(binding);
        }
        return Type.VOID;
    }

    private void typeCheck(Binding binding) throws TypeException {
        binding.typeCheck(Type.UNDEFINED);
    }

    private void createBindings(ParseNode eventTree) throws TypeException {
        if (eventTree == null || eventTree.getTag() == 12) {
            return;
        }
        Bindings bindings = this.getBindings();
        ArrayList<TypeException> exceptions = new ArrayList<TypeException>();
        block6: while (eventTree != null) {
            try {
                int tag = eventTree.getTag();
                switch (tag) {
                    case 5: {
                        ParseNode child0 = (ParseNode)eventTree.getChild(0);
                        eventTree = (ParseNode)eventTree.getChild(1);
                        this.addBinding(bindings, child0);
                        continue block6;
                    }
                    case 1: {
                        ParseNode saveTree = eventTree;
                        eventTree = null;
                        this.addBinding(bindings, saveTree);
                        continue block6;
                    }
                }
                String message = "Event.createBindings : unexpected token Type in binding list " + tag + " for token " + eventTree.getText() + eventTree.getPos();
                eventTree = null;
                throw new TypeException(message);
            }
            catch (TypeException te) {
                exceptions.add(te);
            }
        }
        if (!exceptions.isEmpty()) {
            if (exceptions.size() == 1) {
                throw (TypeException)exceptions.get(0);
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("Event.createBindings : invalid event bindings");
            for (TypeException exception : exceptions) {
                buffer.append("\n\t");
                buffer.append(exception.getMessage());
            }
            throw new TypeException(buffer.toString());
        }
    }

    private void addBinding(Bindings bindings, ParseNode bindingTree) throws TypeException {
        int tag = bindingTree.getTag();
        if (tag != 1) {
            String message = "Event.createBindings : unexpected token Type in binding " + tag + " for token " + bindingTree.getText() + bindingTree.getPos();
            throw new TypeException(message);
        }
        ParseNode varTree = (ParseNode)bindingTree.getChild(0);
        ParseNode exprTree = (ParseNode)bindingTree.getChild(1);
        Binding binding = this.createBinding(varTree);
        Expression expr = ExpressionHelper.createExpression(this.rule, bindings, exprTree, binding.getType());
        expr.bind();
        String name = binding.getName();
        if (bindings.lookup(name) != null) {
            String message = "Event.createBindings : rebinding disallowed for variable " + name + varTree.getPos();
            throw new TypeException(message);
        }
        if (binding.getType() == Type.UNDEFINED && expr.getType() != Type.UNDEFINED) {
            binding.setType(expr.getType());
        }
        binding.setValue(expr);
        bindings.append(binding);
    }

    public Binding createBinding(ParseNode varTree) throws TypeException {
        int tag = varTree.getTag();
        switch (tag) {
            case 9: {
                return new Binding(this.rule, varTree.getText());
            }
            case 6: {
                ParseNode child0 = (ParseNode)varTree.getChild(0);
                ParseNode child1 = (ParseNode)varTree.getChild(1);
                if (child0.getTag() != 9) {
                    throw new TypeException("Event.createBindings : unexpected token type in variable declaration" + child0.getTag() + " for token " + child0.getText() + child0.getPos());
                }
                if (child1.getTag() != 9 && child1.getTag() != 0) {
                    throw new TypeException("Event.createBindings : unexpected token Type in variable type declaration" + child1.getTag() + " for token " + child1.getText() + child1.getPos());
                }
                Type type = this.getBindingType(child1);
                if (type == null) {
                    throw new TypeException("Event.createBindings : incompatible type in declaration of variable " + child1.getText() + child1.getPos());
                }
                return new Binding(this.rule, child0.getText(), type);
            }
        }
        throw new TypeException("Event.createBindings : unexpected token type in binding variable declaration" + tag + " for token " + varTree.getText() + varTree.getPos());
    }

    private Type getBindingType(ParseNode typeTree) {
        int tag = typeTree.getTag();
        switch (tag) {
            case 9: {
                String typeName = typeTree.getText();
                return this.getTypeGroup().create(typeName);
            }
            case 0: {
                ParseNode child0 = (ParseNode)typeTree.getChild(0);
                Type baseType = this.getBindingType(child0);
                if (baseType != null) {
                    return this.getTypeGroup().createArray(baseType);
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        Iterator<Binding> iterator = this.getBindings().iterator();
        while (iterator.hasNext()) {
            Binding binding = iterator.next();
            binding.interpret(helper);
        }
        return null;
    }

    @Override
    public void compile(MethodVisitor mv, StackHeights currentStackHeights, StackHeights maxStackHeights) throws CompileException {
        int currentStack = currentStackHeights.stackCount;
        Iterator<Binding> iterator = this.getBindings().iterator();
        while (iterator.hasNext()) {
            Binding binding = iterator.next();
            binding.compile(mv, currentStackHeights, maxStackHeights);
        }
        if (currentStackHeights.stackCount != currentStack) {
            throw new CompileException("Event.compile : invalid stack height " + currentStackHeights.stackCount + " expecting " + currentStack);
        }
    }

    @Override
    public void writeTo(StringWriter stringWriter) {
        Iterator<Binding> iter = this.getBindings().iterator();
        if (!iter.hasNext()) {
            stringWriter.write("BIND NOTHING");
        } else {
            String prefix = "BIND ";
            while (iter.hasNext()) {
                Binding binding = iter.next();
                stringWriter.write(prefix);
                binding.writeTo(stringWriter);
                prefix = ",\n     ";
            }
        }
        stringWriter.write("\n");
    }
}

