/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import org.jboss.byteman.org.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.StackHeights;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.BinaryOperExpression;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class BitExpression
extends BinaryOperExpression {
    public BitExpression(Rule rule, int oper, ParseNode token, Expression left, Expression right) throws TypeException {
        super(rule, oper, Type.promote(left.getType(), right.getType()), token, left, right);
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        Type type1 = this.getOperand(0).typeCheck(Type.N);
        Type type2 = this.getOperand(1).typeCheck(Type.N);
        this.type = Type.promote(type1, type2);
        if (this.type.isFloating()) {
            this.type = Type.J;
        }
        if (Type.dereference(expected).isDefined() && !expected.isAssignableFrom(this.type)) {
            throw new TypeException("BitExpression.typeCheck : invalid expected result type " + expected.getName() + this.getPos());
        }
        return this.type;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        try {
            char result;
            Number value2;
            Number value1;
            block35: {
                long result2;
                block34: {
                    value1 = (Number)this.getOperand(0).interpret(helper);
                    value2 = (Number)this.getOperand(1).interpret(helper);
                    if (this.type == Type.B) {
                        byte result3;
                        byte b1 = value1.byteValue();
                        byte b2 = value2.byteValue();
                        switch (this.oper) {
                            case 8448: {
                                result3 = (byte)(b1 | b2);
                                break;
                            }
                            case 8449: {
                                result3 = (byte)(b1 & b2);
                                break;
                            }
                            case 8450: {
                                result3 = (byte)(b1 ^ b2);
                                break;
                            }
                            default: {
                                result3 = 0;
                            }
                        }
                        return new Byte(result3);
                    }
                    if (this.type == Type.S) {
                        short result4;
                        short s1 = value1.shortValue();
                        short s2 = value2.shortValue();
                        switch (this.oper) {
                            case 8448: {
                                result4 = (short)(s1 | s2);
                                break;
                            }
                            case 8449: {
                                result4 = (short)(s1 & s2);
                                break;
                            }
                            case 8450: {
                                result4 = (short)(s1 ^ s2);
                                break;
                            }
                            default: {
                                result4 = 0;
                            }
                        }
                        return new Short(result4);
                    }
                    if (this.type == Type.I) {
                        int result5;
                        int i1 = value1.intValue();
                        int i2 = value2.intValue();
                        switch (this.oper) {
                            case 8448: {
                                result5 = i1 | i2;
                                break;
                            }
                            case 8449: {
                                result5 = i1 & i2;
                                break;
                            }
                            case 8450: {
                                result5 = i1 ^ i2;
                                break;
                            }
                            default: {
                                result5 = 0;
                            }
                        }
                        return new Integer(result5);
                    }
                    if (this.type == Type.J) break block34;
                    if (this.type == Type.F) break block34;
                    if (this.type != Type.D) break block35;
                }
                long l1 = value1.longValue();
                long l2 = value2.longValue();
                switch (this.oper) {
                    case 8448: {
                        result2 = l1 | l2;
                        break;
                    }
                    case 8449: {
                        result2 = l1 & l2;
                        break;
                    }
                    case 8450: {
                        result2 = l1 ^ l2;
                        break;
                    }
                    default: {
                        result2 = 0L;
                    }
                }
                return new Long(result2);
            }
            int s1 = value1.intValue();
            int s2 = value2.intValue();
            switch (this.oper) {
                case 8448: {
                    result = (char)(s1 | s2);
                    break;
                }
                case 8449: {
                    result = (char)(s1 & s2);
                    break;
                }
                case 8450: {
                    result = (char)(s1 ^ s2);
                    break;
                }
                default: {
                    result = '\u0000';
                }
            }
            return new Integer(result);
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecuteException("BitExpression.interpret : unexpected exception for operation " + this.token + this.getPos() + " in rule " + helper.getName(), e);
        }
    }

    @Override
    public void compile(MethodVisitor mv, StackHeights currentStackHeights, StackHeights maxStackHeights) throws CompileException {
        int currentStack = currentStackHeights.stackCount;
        int expected = 0;
        Expression oper0 = this.getOperand(0);
        Expression oper1 = this.getOperand(1);
        oper0.compile(mv, currentStackHeights, maxStackHeights);
        this.compileTypeConversion(oper0.getType(), this.type, mv, currentStackHeights, maxStackHeights);
        oper1.compile(mv, currentStackHeights, maxStackHeights);
        this.compileTypeConversion(oper1.getType(), this.type, mv, currentStackHeights, maxStackHeights);
        if (this.type == Type.B || this.type == Type.S || this.type == Type.C || this.type == Type.I) {
            switch (this.oper) {
                case 8448: {
                    mv.visitInsn(128);
                    break;
                }
                case 8449: {
                    mv.visitInsn(126);
                    break;
                }
                case 8450: {
                    mv.visitInsn(130);
                }
            }
            if (this.type == Type.B) {
                mv.visitInsn(145);
            } else if (this.type == Type.S) {
                mv.visitInsn(147);
            } else if (this.type == Type.C) {
                mv.visitInsn(146);
            }
            expected = 1;
        } else if (this.type == Type.J) {
            switch (this.oper) {
                case 8448: {
                    mv.visitInsn(129);
                    break;
                }
                case 8449: {
                    mv.visitInsn(127);
                    break;
                }
                case 8450: {
                    mv.visitInsn(131);
                }
            }
            expected = 2;
        } else if (this.type == Type.F) {
            mv.visitInsn(140);
            switch (this.oper) {
                case 8448: {
                    mv.visitInsn(129);
                    break;
                }
                case 8449: {
                    mv.visitInsn(127);
                    break;
                }
                case 8450: {
                    mv.visitInsn(131);
                }
            }
            expected = 2;
        } else if (this.type == Type.D) {
            mv.visitInsn(143);
            switch (this.oper) {
                case 8448: {
                    mv.visitInsn(129);
                    break;
                }
                case 8449: {
                    mv.visitInsn(127);
                    break;
                }
                case 8450: {
                    mv.visitInsn(131);
                }
            }
            expected = 2;
        }
        currentStackHeights.addStackCount(expected);
        if (currentStackHeights.stackCount != currentStack + expected) {
            throw new CompileException("BitExpression.compile : invalid stack height " + currentStackHeights.stackCount + " expecting " + currentStack + expected);
        }
        int maxStack = maxStackHeights.stackCount;
        int overflow = currentStack + 2 * expected - maxStack;
        if (overflow > 0) {
            maxStackHeights.addStackCount(overflow);
        }
    }
}

