/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import java.io.StringWriter;
import java.lang.reflect.Field;
import org.jboss.byteman.org.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.binding.Binding;
import org.jboss.byteman.rule.compiler.StackHeights;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.AssignableExpression;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.expression.StaticExpression;
import org.jboss.byteman.rule.expression.Variable;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;
import org.jboss.byteman.rule.type.TypeGroup;

public class FieldExpression
extends AssignableExpression {
    private Expression owner;
    private String[] pathList;
    private String fieldName;
    private Type ownerType;
    private Field field;
    private AssignableExpression indirectStatic;

    public FieldExpression(Rule rule, Type type, ParseNode fieldTree, String fieldName, Expression owner, String[] pathList) {
        super(rule, type, fieldTree);
        this.fieldName = fieldName;
        this.owner = owner;
        this.pathList = pathList;
        this.ownerType = null;
        this.indirectStatic = null;
    }

    @Override
    public void bind() throws TypeException {
        if (this.owner != null) {
            this.owner.bind();
        } else {
            String leading = this.pathList[0];
            Binding binding = this.getBindings().lookup(leading);
            if (binding != null) {
                int l = this.pathList.length;
                AssignableExpression owner = new Variable(this.rule, binding.getType(), this.token, binding.getName());
                for (int idx = 1; idx < l; ++idx) {
                    owner = new FieldExpression(this.rule, Type.UNDEFINED, this.token, this.pathList[idx], owner, null);
                }
                this.owner = owner;
                this.pathList = null;
                this.owner.bind();
            }
        }
    }

    @Override
    public void bindAssign() throws TypeException {
        this.bind();
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        if (this.owner == null && this.pathList != null) {
            TypeGroup typeGroup = this.getTypeGroup();
            Type rootType = typeGroup.match(this.pathList);
            if (rootType == null) {
                throw new TypeException("FieldExpression.typeCheck : invalid path " + this.getPath(this.pathList.length) + " to static field " + this.fieldName + this.getPos());
            }
            String rootTypeName = rootType.getName();
            int idx = this.getPathCount(rootTypeName);
            if (idx < this.pathList.length) {
                String fieldName = this.pathList[idx++];
                AssignableExpression owner = new StaticExpression(this.rule, Type.UNDEFINED, this.token, fieldName, rootTypeName);
                while (idx < this.pathList.length) {
                    owner = new FieldExpression(this.rule, Type.UNDEFINED, this.token, this.pathList[idx++], owner, null);
                }
                this.owner = owner;
                this.owner.bind();
            } else {
                this.indirectStatic = new StaticExpression(this.rule, Type.UNDEFINED, this.token, this.fieldName, rootTypeName);
                this.indirectStatic.bind();
            }
            this.pathList = null;
        }
        if (this.indirectStatic != null) {
            this.type = Type.dereference(this.indirectStatic.typeCheck(expected));
            return this.type;
        }
        this.ownerType = Type.dereference(this.owner.typeCheck(Type.UNDEFINED));
        if (this.ownerType.isUndefined()) {
            throw new TypeException("FieldExpresssion.typeCheck : unbound owner type for field " + this.fieldName + this.getPos());
        }
        Class ownerClazz = this.ownerType.getTargetClass();
        Class<?> valueClass = null;
        try {
            this.field = ownerClazz.getField(this.fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new TypeException("FieldExpresssion.typeCheck : invalid field reference " + this.fieldName + this.getPos());
        }
        if ((this.field.getModifiers() & 8) != 0) {
            throw new TypeException("FieldExpresssion.typeCheck : field is static " + this.fieldName + this.getPos());
        }
        valueClass = this.field.getType();
        this.type = this.getTypeGroup().ensureType(valueClass);
        if (Type.dereference(expected).isDefined() && !expected.isAssignableFrom(this.type)) {
            throw new TypeException("FieldExpresssion.typeCheck : invalid expected type " + expected.getName() + this.getPos());
        }
        return this.type;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        if (this.indirectStatic != null) {
            return this.indirectStatic.interpret(helper);
        }
        try {
            Object value = this.owner.interpret(helper);
            if (value == null) {
                throw new ExecuteException("FieldExpression.interpret : attempted field indirection through null value " + this.token.getText() + this.getPos());
            }
            return this.field.get(value);
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new ExecuteException("FieldExpression.interpret : error accessing field " + this.fieldName + this.getPos(), e);
        }
        catch (Exception e) {
            throw new ExecuteException("FieldExpression.interpret : unexpected exception accessing field " + this.fieldName + this.getPos(), e);
        }
    }

    @Override
    public void compile(MethodVisitor mv, StackHeights currentStackHeights, StackHeights maxStackHeights) throws CompileException {
        int expected;
        int currentStack = currentStackHeights.stackCount;
        int n = expected = this.type.getNBytes() > 4 ? 2 : 1;
        if (this.indirectStatic != null) {
            this.indirectStatic.compile(mv, currentStackHeights, maxStackHeights);
        } else {
            this.owner.compile(mv, currentStackHeights, maxStackHeights);
            String ownerType = Type.internalName(this.field.getDeclaringClass());
            String fieldName = this.field.getName();
            String fieldType = Type.internalName(this.field.getType(), true);
            mv.visitFieldInsn(180, ownerType, fieldName, fieldType);
        }
        if (currentStackHeights.stackCount != currentStack + expected) {
            throw new CompileException("FieldExpression.compile : invalid stack height " + currentStackHeights.stackCount + " expecting " + (currentStack + expected));
        }
        int overflow = currentStack + expected - maxStackHeights.stackCount;
        if (overflow > 0) {
            maxStackHeights.addStackCount(overflow);
        }
    }

    public String getPath(int len) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.pathList[0]);
        for (int i = 1; i < len; ++i) {
            buffer.append(".");
            buffer.append(this.pathList[i]);
        }
        return buffer.toString();
    }

    public int getPathCount(String name) {
        if (name.startsWith(this.pathList[0])) {
            int idx;
            int charMax = name.length();
            int charCount = 0;
            int dotExtra = 0;
            for (idx = 0; idx < this.pathList.length && (charCount += dotExtra + this.pathList[idx].length()) <= charMax; ++idx) {
            }
            return idx;
        }
        return 1;
    }

    @Override
    public void writeTo(StringWriter stringWriter) {
        if (this.owner != null) {
            this.owner.writeTo(stringWriter);
        } else {
            String sepr = "";
            for (String field : this.pathList) {
                stringWriter.write(sepr);
                stringWriter.write(field);
                sepr = ".";
            }
        }
        stringWriter.write(".");
        stringWriter.write(this.fieldName);
    }

    @Override
    public Object interpretAssign(HelperAdapter helperAdapter, Object value) throws ExecuteException {
        if (this.indirectStatic != null) {
            return this.indirectStatic.interpretAssign(helperAdapter, value);
        }
        try {
            Object ownerInstance = this.owner.interpret(helperAdapter);
            if (ownerInstance == null) {
                throw new ExecuteException("FieldExpression.interpret : attempted field indirection through null value " + this.token.getText() + this.getPos());
            }
            this.field.set(ownerInstance, value);
            return value;
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new ExecuteException("FieldExpression.interpretAssign : error accessing field " + this.fieldName + this.getPos(), e);
        }
        catch (IllegalArgumentException e) {
            throw new ExecuteException("FieldExpression.interpretAssign : invalid value assigning field " + this.fieldName + this.getPos(), e);
        }
        catch (Exception e) {
            throw new ExecuteException("FieldExpression.interpretAssign : unexpected exception accessing field " + this.fieldName + this.getPos(), e);
        }
    }

    @Override
    public void compileAssign(MethodVisitor mv, StackHeights currentStackHeights, StackHeights maxStackHeights) throws CompileException {
        if (this.indirectStatic != null) {
            this.indirectStatic.compileAssign(mv, currentStackHeights, maxStackHeights);
        } else {
            int currentStack = currentStackHeights.stackCount;
            int size = this.type.getNBytes() > 4 ? 2 : 1;
            int expected = 0;
            if (size == 1) {
                mv.visitInsn(89);
            } else {
                mv.visitInsn(92);
            }
            this.owner.compile(mv, currentStackHeights, maxStackHeights);
            if (size == 1) {
                mv.visitInsn(95);
                int max = 2;
            } else {
                mv.visitInsn(91);
                mv.visitInsn(87);
                int max = 4;
            }
            String ownerType = Type.internalName(this.field.getDeclaringClass());
            String fieldName = this.field.getName();
            String fieldType = Type.internalName(this.field.getType(), true);
            mv.visitFieldInsn(181, ownerType, fieldName, fieldType);
            currentStackHeights.addStackCount(-1);
            if (currentStackHeights.stackCount != currentStack + expected) {
                throw new CompileException("FieldExpression.compileAssign : invalid stack height " + currentStackHeights.stackCount + " expecting " + (currentStack + expected));
            }
            int overflow = currentStack + 2 - maxStackHeights.stackCount;
            if (overflow > 0) {
                maxStackHeights.addStackCount(overflow);
            }
        }
    }
}

