/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.byteman.org.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.binding.Binding;
import org.jboss.byteman.rule.compiler.StackHeights;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.AssignableExpression;
import org.jboss.byteman.rule.expression.DollarExpression;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.expression.FieldExpression;
import org.jboss.byteman.rule.expression.StaticExpression;
import org.jboss.byteman.rule.expression.Variable;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;
import org.jboss.byteman.rule.type.TypeGroup;

public class MethodExpression
extends Expression {
    private String name;
    private List<Expression> arguments;
    private List<Type> argumentTypes;
    private List<Type> paramTypes;
    private Expression recipient;
    private Type rootType;
    private Method method;
    String[] pathList;

    public MethodExpression(Rule rule, Type type, ParseNode token, Expression recipient, List<Expression> arguments, String[] pathList) {
        super(rule, type, token);
        this.name = token.getText();
        this.recipient = recipient;
        this.arguments = arguments;
        this.argumentTypes = null;
        this.paramTypes = null;
        this.rootType = null;
        this.pathList = pathList;
    }

    @Override
    public void bind() throws TypeException {
        if (this.recipient != null) {
            this.recipient.bind();
        } else if (this.pathList != null) {
            String leading = this.pathList[0];
            Binding binding = this.getBindings().lookup(leading);
            if (binding != null) {
                int l = this.pathList.length;
                AssignableExpression recipient = new Variable(this.rule, binding.getType(), this.token, binding.getName());
                for (int idx = 1; idx < l; ++idx) {
                    recipient = new FieldExpression(this.rule, Type.UNDEFINED, this.token, this.pathList[idx], recipient, null);
                }
                this.recipient = recipient;
                this.pathList = null;
                this.recipient.bind();
            }
        }
        Iterator<Expression> iterator = this.arguments.iterator();
        while (iterator.hasNext()) {
            iterator.next().bind();
        }
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        TypeGroup typeGroup = this.getTypeGroup();
        if (this.recipient == null && this.pathList != null) {
            Type rootType = typeGroup.match(this.pathList);
            if (rootType == null) {
                throw new TypeException("FieldExpression.typeCheck : invalid path " + this.getPath(this.pathList.length) + " to static method " + this.name + this.getPos());
            }
            String rootTypeName = rootType.getName();
            int idx = this.getPathCount(rootTypeName);
            if (idx < this.pathList.length) {
                String fieldName = this.pathList[idx++];
                AssignableExpression recipient = new StaticExpression(this.rule, Type.UNDEFINED, this.token, fieldName, rootTypeName);
                while (idx < this.pathList.length) {
                    recipient = new FieldExpression(this.rule, Type.UNDEFINED, this.token, this.pathList[idx++], recipient, null);
                }
                this.recipient = recipient;
            } else {
                this.recipient = null;
                this.rootType = rootType;
            }
            this.pathList = null;
            if (this.recipient != null) {
                this.recipient.bind();
            }
        }
        if (this.recipient == null) {
            if (this.rootType == null) {
                Type ruleType = typeGroup.create(this.rule.getHelperClass().getCanonicalName());
                this.recipient = new DollarExpression(this.rule, ruleType, this.token, -1);
                this.recipient.bind();
                this.rootType = this.recipient.typeCheck(Type.UNDEFINED);
            }
        } else {
            this.rootType = this.recipient.typeCheck(Type.UNDEFINED);
        }
        boolean isStatic = this.recipient == null;
        Class clazz = this.rootType.getTargetClass();
        int arity = this.arguments.size();
        Method[] methods = clazz.getMethods();
        List<Method> candidates = new ArrayList<Method>();
        boolean duplicates = false;
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers) != isStatic || !method.getName().equals(this.name) || method.getParameterTypes().length != arity) continue;
            candidates.add(method);
        }
        this.argumentTypes = new ArrayList<Type>();
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (candidates.isEmpty()) {
                throw new TypeException("MethodExpression.typeCheck : invalid method " + this.name + " for target class " + this.rootType.getName() + this.getPos());
            }
            Class candidateClass = this.getCandidateArgClass(candidates, i);
            Type candidateType = candidateClass != null ? typeGroup.ensureType(candidateClass) : Type.UNDEFINED;
            Type argType = this.arguments.get(i).typeCheck(candidateType);
            this.argumentTypes.add(argType);
            if (candidateType != Type.UNDEFINED) continue;
            candidates = this.pruneCandidates(candidates, i, argType.getTargetClass());
        }
        if (candidates.isEmpty()) {
            throw new TypeException("MethodExpression.typeCheck : invalid method " + this.name + " for target class " + this.rootType.getName() + this.getPos());
        }
        if (candidates.size() > 1) {
            throw new TypeException("MethodExpression.typeCheck : ambiguous method signature " + this.name + " for target class " + this.rootType.getName() + this.getPos());
        }
        this.method = (Method)candidates.get(0);
        this.paramTypes = new ArrayList<Type>();
        Class<?>[] paramClasses = this.method.getParameterTypes();
        for (int i = 0; i < this.arguments.size(); ++i) {
            Class<?> paramClass = paramClasses[i];
            this.paramTypes.add(typeGroup.ensureType(paramClass));
        }
        this.type = typeGroup.ensureType(this.method.getReturnType());
        if (Type.dereference(expected).isDefined() && !expected.isAssignableFrom(this.type)) {
            throw new TypeException("MethodExpression.typeCheck : invalid expected type " + expected.getName() + this.getPos());
        }
        return this.type;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        Object recipientValue = null;
        try {
            if (this.recipient != null && (recipientValue = this.recipient.interpret(helper)) == null) {
                throw new ExecuteException("MethodExpression.interpret : null recipient for method " + this.token.getText() + this.getPos());
            }
            int argCount = this.arguments.size();
            Object[] argValues = new Object[argCount];
            for (int i = 0; i < argCount; ++i) {
                argValues[i] = this.arguments.get(i).interpret(helper);
            }
            Rule.enableTriggersInternal();
            Object object = this.method.invoke(recipientValue, argValues);
            return object;
        }
        catch (InvocationTargetException e) {
            Throwable th = e.getCause();
            if (th instanceof ExecuteException) {
                throw (ExecuteException)th;
            }
            throw new ExecuteException("MethodExpression.interpret : exception invoking method " + this.token.getText() + this.getPos(), th);
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecuteException("MethodExpression.interpret : exception invoking method " + this.token.getText() + this.getPos(), e);
        }
        finally {
            Rule.disableTriggersInternal();
        }
    }

    @Override
    public void compile(MethodVisitor mv, StackHeights currentStackHeights, StackHeights maxStackHeights) throws CompileException {
        int currentStack = currentStackHeights.stackCount;
        int extraParams = 0;
        int expected = 0;
        if (this.recipient != null) {
            this.recipient.compile(mv, currentStackHeights, maxStackHeights);
            ++extraParams;
        }
        int argCount = this.arguments.size();
        for (int i = 0; i < argCount; ++i) {
            Expression argument = this.arguments.get(i);
            Type argType = this.argumentTypes.get(i);
            Type paramType = this.paramTypes.get(i);
            argument.compile(mv, currentStackHeights, maxStackHeights);
            this.compileTypeConversion(argType, paramType, mv, currentStackHeights, maxStackHeights);
            extraParams += paramType.getNBytes() > 4 ? 2 : 1;
        }
        mv.visitMethodInsn(184, "org/jboss/byteman/rule/Rule", "enableTriggersInternal", "()Z");
        mv.visitInsn(87);
        if (maxStackHeights.stackCount == currentStackHeights.stackCount) {
            ++maxStackHeights.stackCount;
        }
        String ownerName = Type.internalName(this.method.getDeclaringClass());
        if (this.recipient == null) {
            mv.visitMethodInsn(184, ownerName, this.method.getName(), this.getDescriptor());
        } else if (this.recipient.getClass().isInterface()) {
            mv.visitMethodInsn(185, ownerName, this.method.getName(), this.getDescriptor());
        } else {
            mv.visitMethodInsn(182, ownerName, this.method.getName(), this.getDescriptor());
        }
        mv.visitMethodInsn(184, "org/jboss/byteman/rule/Rule", "disableTriggersInternal", "()Z");
        mv.visitInsn(87);
        expected = this.type.getNBytes() > 4 ? 2 : (this.type != Type.VOID ? 1 : 0);
        currentStackHeights.addStackCount(expected - extraParams);
        if (currentStackHeights.stackCount != currentStack + expected) {
            throw new CompileException("MethodExpression.compile : invalid stack height " + currentStackHeights.stackCount + " expecting " + (currentStack + expected));
        }
    }

    private String getDescriptor() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        int nParams = this.paramTypes.size();
        for (int i = 0; i < nParams; ++i) {
            buffer.append(this.paramTypes.get(i).getInternalName(true, true));
        }
        buffer.append(")");
        buffer.append(this.type.getInternalName(true, true));
        return buffer.toString();
    }

    public Class getCandidateArgClass(List<Method> candidates, int argIdx) {
        Class<?> argClazz = null;
        for (Method m : candidates) {
            Class<?> nextClazz = m.getParameterTypes()[argIdx];
            if (argClazz == null) {
                argClazz = nextClazz;
                continue;
            }
            if (argClazz == nextClazz) continue;
            return null;
        }
        return argClazz;
    }

    public List<Method> pruneCandidates(List<Method> candidates, int argIdx, Class argClazz) {
        int i = 0;
        while (i < candidates.size()) {
            Method m = candidates.get(i);
            Class<?> nextClazz = m.getParameterTypes()[argIdx];
            if (nextClazz != argClazz) {
                candidates.remove(i);
                continue;
            }
            ++i;
        }
        return candidates;
    }

    public String getPath(int len) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.pathList[0]);
        for (int i = 1; i < len; ++i) {
            buffer.append(".");
            buffer.append(this.pathList[i]);
        }
        return buffer.toString();
    }

    public int getPathCount(String name) {
        if (name.startsWith(this.pathList[0])) {
            int idx;
            int charMax = name.length();
            int charCount = 0;
            int dotExtra = 0;
            for (idx = 0; idx < this.pathList.length && (charCount += dotExtra + this.pathList[idx].length()) <= charMax; ++idx) {
            }
            return idx;
        }
        return 1;
    }

    @Override
    public void writeTo(StringWriter stringWriter) {
        if (this.recipient != null) {
            this.recipient.writeTo(stringWriter);
            stringWriter.write(".");
        } else if (this.pathList != null) {
            stringWriter.write(this.getPath(this.pathList.length));
            stringWriter.write(".");
        }
        stringWriter.write(this.name);
        stringWriter.write("(");
        String sepr = "";
        for (Expression arg : this.arguments) {
            stringWriter.write(sepr);
            arg.writeTo(stringWriter);
            sepr = ", ";
        }
        stringWriter.write(")");
    }
}

