/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import java.io.StringWriter;
import org.jboss.byteman.org.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.StackHeights;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class NullLiteral
extends Expression {
    public NullLiteral(Rule rule, ParseNode token) {
        super(rule, Type.UNDEFINED, token);
    }

    @Override
    public void bind() {
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        if (expected.isPrimitive()) {
            this.type = Type.boxType(expected);
        } else {
            this.type = expected;
            if (this.type.isUndefined()) {
                throw new TypeException("NullLiteral.typeCheck : unable to derive type for null from context");
            }
        }
        return this.type;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        return null;
    }

    @Override
    public void compile(MethodVisitor mv, StackHeights currentStackHeights, StackHeights maxStackHeights) throws CompileException {
        int currentStack = currentStackHeights.stackCount;
        int expected = 1;
        mv.visitInsn(1);
        currentStackHeights.addStackCount(expected);
        int overflow = currentStack + expected - maxStackHeights.stackCount;
        if (overflow > 0) {
            maxStackHeights.addStackCount(overflow);
        }
    }

    @Override
    public void writeTo(StringWriter stringWriter) {
        stringWriter.write("null");
    }
}

