/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import java.io.StringWriter;
import java.lang.reflect.Field;
import org.jboss.byteman.org.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.StackHeights;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.AssignableExpression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;
import org.jboss.byteman.rule.type.TypeGroup;

public class StaticExpression
extends AssignableExpression {
    private String ownerTypeName;
    private String fieldName;
    private Field field;
    private Type ownerType;

    public StaticExpression(Rule rule, Type type, ParseNode token, String fieldName, String ownerTypeName) {
        super(rule, type, token);
        this.ownerTypeName = ownerTypeName;
        this.fieldName = fieldName;
        this.ownerType = null;
    }

    @Override
    public void bind() throws TypeException {
    }

    @Override
    public void bindAssign() throws TypeException {
        this.bind();
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        TypeGroup typeGroup = this.getTypeGroup();
        this.ownerType = Type.dereference(typeGroup.create(this.ownerTypeName));
        if (this.ownerType.isUndefined()) {
            throw new TypeException("StaticExpression.typeCheck : invalid path " + this.ownerTypeName + " to static field " + this.fieldName + this.getPos());
        }
        Class<?> clazz = this.ownerType.getTargetClass();
        try {
            this.field = clazz.getField(this.fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new TypeException("StaticExpression.typeCheck : invalid field name " + this.fieldName + this.getPos());
        }
        if ((this.field.getModifiers() & 8) == 0) {
            throw new TypeException("StaticExpression.typeCheck : field is not static " + this.fieldName + this.getPos());
        }
        clazz = this.field.getType();
        this.type = typeGroup.ensureType(clazz);
        if (Type.dereference(expected).isDefined() && !expected.isAssignableFrom(this.type)) {
            throw new TypeException("StaticExpression.typeCheck : invalid expected return type " + expected.getName() + this.getPos());
        }
        return this.type;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        try {
            return this.field.get(null);
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new ExecuteException("StaticExpression.interpret : error accessing field " + this.ownerTypeName + "." + this.fieldName + this.getPos(), e);
        }
        catch (Exception e) {
            throw new ExecuteException("StaticExpression.interpret : unexpected exception accessing field " + this.ownerTypeName + "." + this.fieldName + this.getPos(), e);
        }
    }

    @Override
    public void compile(MethodVisitor mv, StackHeights currentStackHeights, StackHeights maxStackHeights) throws CompileException {
        int currentStack = currentStackHeights.stackCount;
        String ownerType = Type.internalName(this.field.getDeclaringClass());
        String fieldName = this.field.getName();
        String fieldType = Type.internalName(this.field.getType(), true);
        mv.visitFieldInsn(178, ownerType, fieldName, fieldType);
        int expected = this.type.getNBytes() > 4 ? 2 : 1;
        currentStackHeights.addStackCount(expected);
        int overflow = currentStack + expected - maxStackHeights.stackCount;
        if (overflow > 0) {
            maxStackHeights.addStackCount(overflow);
        }
    }

    @Override
    public void writeTo(StringWriter stringWriter) {
        stringWriter.write(this.ownerTypeName);
        stringWriter.write(".");
        stringWriter.write(this.fieldName);
    }

    @Override
    public Object interpretAssign(HelperAdapter helperAdapter, Object value) throws ExecuteException {
        try {
            this.field.set(null, value);
            return value;
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new ExecuteException("StaticExpression.interpretAssign : error accessing field " + this.ownerTypeName + "." + this.fieldName + this.getPos(), e);
        }
        catch (IllegalArgumentException e) {
            throw new ExecuteException("StaticExpression.interpretAssign : invalid value assigning field " + this.ownerTypeName + "." + this.fieldName + this.getPos(), e);
        }
        catch (Exception e) {
            throw new ExecuteException("StaticExpression.interpretAssign : unexpected exception accessing field " + this.ownerTypeName + "." + this.fieldName + this.getPos(), e);
        }
    }

    @Override
    public void compileAssign(MethodVisitor mv, StackHeights currentStackHeights, StackHeights maxStackHeights) throws CompileException {
        int size;
        int currentStack = currentStackHeights.stackCount;
        int n = size = this.type.getNBytes() > 4 ? 2 : 1;
        if (size == 1) {
            mv.visitInsn(89);
        } else {
            mv.visitInsn(92);
        }
        String ownerType = Type.internalName(this.field.getDeclaringClass());
        String fieldName = this.field.getName();
        String fieldType = Type.internalName(this.field.getType(), true);
        mv.visitFieldInsn(179, ownerType, fieldName, fieldType);
        int overflow = currentStack + size - maxStackHeights.stackCount;
        if (overflow > 0) {
            maxStackHeights.addStackCount(overflow);
        }
    }
}

