/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import org.jboss.byteman.org.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.StackHeights;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.BinaryOperExpression;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class StringPlusExpression
extends BinaryOperExpression {
    public StringPlusExpression(Rule rule, ParseNode token, Expression left, Expression right) {
        super(rule, 8707, Type.STRING, token, left, right);
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        Type type1 = this.getOperand(0).typeCheck(Type.STRING);
        Type type2 = this.getOperand(1).typeCheck(Type.STRING);
        if (Type.dereference(expected).isDefined() && !expected.isAssignableFrom(Type.STRING)) {
            throw new TypeException("StringPlusExpression.typeCheck : invalid expected result type " + expected.getName() + this.getPos());
        }
        return this.type;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        Object value1 = this.getOperand(0).interpret(helper);
        Object value2 = this.getOperand(1).interpret(helper);
        String string1 = value1.toString();
        String string2 = value2 == null ? "null" : value2.toString();
        return string1 + string2;
    }

    @Override
    public void compile(MethodVisitor mv, StackHeights currentStackHeights, StackHeights maxStackHeights) throws CompileException {
        Expression oper0 = this.getOperand(0);
        Expression oper1 = this.getOperand(1);
        int currentStack = currentStackHeights.stackCount;
        int expected = 2;
        oper0.compile(mv, currentStackHeights, maxStackHeights);
        this.compileTypeConversion(oper0.getType(), this.type, mv, currentStackHeights, maxStackHeights);
        oper1.compile(mv, currentStackHeights, maxStackHeights);
        this.compileTypeConversion(oper1.getType(), this.type, mv, currentStackHeights, maxStackHeights);
        expected = 1;
        mv.visitMethodInsn(182, "java/lang/String", "concat", "(Ljava/lang/String;)Ljava/lang/String;");
        currentStackHeights.addStackCount(-1);
        if (currentStackHeights.stackCount != currentStack + expected) {
            throw new CompileException("StringPlusExpression.compile : invalid stack height " + currentStackHeights.stackCount + " expecting " + currentStack + expected);
        }
        int overflow = currentStack + 2 * expected - maxStackHeights.stackCount;
        if (overflow > 0) {
            maxStackHeights.addStackCount(overflow);
        }
    }
}

