/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.byteman.org.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.StackHeights;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.ThrowException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;
import org.jboss.byteman.rule.type.TypeGroup;

public class ThrowExpression
extends Expression {
    private String typeName;
    private List<Expression> arguments;
    private List<Type> argumentTypes;
    private List<Type> paramTypes;
    private Constructor constructor;

    public ThrowExpression(Rule rule, ParseNode token, List<Expression> arguments) {
        super(rule, Type.UNDEFINED, token);
        this.typeName = token.getText();
        this.arguments = arguments;
        this.argumentTypes = null;
        this.constructor = null;
    }

    @Override
    public void bind() throws TypeException {
        Iterator<Expression> iterator = this.arguments.iterator();
        while (iterator.hasNext()) {
            iterator.next().bind();
        }
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        TypeGroup typeGroup = this.getTypeGroup();
        this.type = Type.dereference(typeGroup.create(this.typeName));
        if (this.type == null || this.type.isUndefined()) {
            throw new TypeException("ThrowExpression.typeCheck : unknown exception type " + this.typeName + this.getPos());
        }
        if (!Throwable.class.isAssignableFrom(this.type.getTargetClass())) {
            throw new TypeException("ThrowExpression.typeCheck : not an exception type " + this.typeName + this.getPos());
        }
        Class clazz = this.type.getTargetClass();
        int arity = this.arguments.size();
        Constructor<?>[] constructors = clazz.getConstructors();
        List<Constructor> candidates = new ArrayList<Constructor>();
        boolean duplicates = false;
        for (Constructor<?> constructor : constructors) {
            if (constructor.getParameterTypes().length != arity) continue;
            candidates.add(constructor);
        }
        this.argumentTypes = new ArrayList<Type>();
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (candidates.isEmpty()) {
                throw new TypeException("ThrowExpression.typeCheck : invalid constructor for target class " + this.typeName + this.getPos());
            }
            Class candidateClass = this.getCandidateArgClass(candidates, i);
            Type candidateType = candidateClass != null ? typeGroup.ensureType(candidateClass) : Type.UNDEFINED;
            Type argType = this.arguments.get(i).typeCheck(candidateType);
            this.argumentTypes.add(argType);
            if (candidateType != Type.UNDEFINED) continue;
            candidates = this.pruneCandidates(candidates, i, argType.getTargetClass());
        }
        if (candidates.isEmpty()) {
            throw new TypeException("ThrowExpression.typeCheck : invalid constructor for target class " + this.typeName + this.getPos());
        }
        if (candidates.size() > 1) {
            throw new TypeException("ThrowExpression.typeCheck : ambiguous constructor signature for target class " + this.typeName + this.getPos());
        }
        this.constructor = (Constructor)candidates.get(0);
        this.paramTypes = new ArrayList<Type>();
        Class<?>[] paramClasses = this.constructor.getParameterTypes();
        for (int i = 0; i < this.arguments.size(); ++i) {
            this.paramTypes.add(typeGroup.ensureType(paramClasses[i]));
        }
        if (RuntimeException.class.isAssignableFrom(this.type.getTargetClass())) {
            return this.type;
        }
        for (Type exceptionType : typeGroup.getExceptionTypes()) {
            if (!Type.dereference(exceptionType).isAssignableFrom(this.type)) continue;
            return this.type;
        }
        throw new TypeException("ThrowExpression.typeCheck : exception type not declared by trigger method " + this.typeName + this.getPos());
    }

    public Class getCandidateArgClass(List<Constructor> candidates, int argIdx) {
        Class<?> argClazz = null;
        for (Constructor c : candidates) {
            Class<?> nextClazz = c.getParameterTypes()[argIdx];
            if (argClazz == null) {
                argClazz = nextClazz;
                continue;
            }
            if (argClazz == nextClazz) continue;
            return null;
        }
        return argClazz;
    }

    public List<Constructor> pruneCandidates(List<Constructor> candidates, int argIdx, Class argClazz) {
        int i = 0;
        while (i < candidates.size()) {
            Constructor c = candidates.get(i);
            Class<?> nextClazz = c.getParameterTypes()[argIdx];
            if (nextClazz != argClazz) {
                candidates.remove(i);
                continue;
            }
            ++i;
        }
        return candidates;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        int l = this.arguments.size();
        Object[] callArgs = new Object[l];
        for (int i = 0; i < l; ++i) {
            callArgs[i] = this.arguments.get(i).interpret(helper);
        }
        try {
            Throwable th = (Throwable)this.constructor.newInstance(callArgs);
            ThrowException thex = new ThrowException(th);
            throw thex;
        }
        catch (InstantiationException e) {
            throw new ExecuteException("ThrowExpression.interpret : unable to instantiate exception class " + this.typeName + this.getPos(), e);
        }
        catch (IllegalAccessException e) {
            throw new ExecuteException("ThrowExpression.interpret : unable to access exception class " + this.typeName + this.getPos(), e);
        }
        catch (InvocationTargetException e) {
            throw new ExecuteException("ThrowExpression.interpret : unable to invoke exception class constructor for " + this.typeName + this.getPos(), e);
        }
    }

    @Override
    public void compile(MethodVisitor mv, StackHeights currentStackHeights, StackHeights maxStackHeights) throws CompileException {
        int overflow;
        int currentStack = currentStackHeights.stackCount;
        int expected = 1;
        int extraParams = 0;
        String exceptionClassName = this.type.getInternalName();
        mv.visitTypeInsn(187, exceptionClassName);
        currentStackHeights.addStackCount(1);
        mv.visitInsn(89);
        currentStackHeights.addStackCount(1);
        int argCount = this.arguments.size();
        for (int i = 0; i < argCount; ++i) {
            Type argType = this.argumentTypes.get(i);
            Type paramType = this.paramTypes.get(i);
            int paramCount = paramType.getNBytes() > 4 ? 2 : 1;
            extraParams += paramCount;
            this.arguments.get(i).compile(mv, currentStackHeights, maxStackHeights);
            this.compileTypeConversion(argType, paramType, mv, currentStackHeights, maxStackHeights);
        }
        mv.visitMethodInsn(183, exceptionClassName, "<init>", this.getDescriptor());
        currentStackHeights.addStackCount(-(extraParams + 1));
        if (currentStackHeights.stackCount != currentStack + expected) {
            throw new CompileException("ThrowExpression.compile : invalid stack height " + currentStackHeights.stackCount + " expecting " + (currentStack + expected));
        }
        exceptionClassName = "org/jboss/byteman/rule/exception/ThrowException";
        mv.visitTypeInsn(187, exceptionClassName);
        currentStackHeights.addStackCount(1);
        mv.visitInsn(90);
        currentStackHeights.addStackCount(1);
        mv.visitInsn(95);
        mv.visitMethodInsn(183, exceptionClassName, "<init>", "(Ljava/lang/Throwable;)V");
        currentStackHeights.addStackCount(-2);
        if (currentStackHeights.stackCount != currentStack + expected) {
            throw new CompileException("ThrowExpression.compile : invalid stack height " + currentStackHeights.stackCount + " expecting " + (currentStack + expected));
        }
        mv.visitInsn(191);
        currentStackHeights.addStackCount(-1);
        if (extraParams < 1 && (overflow = currentStack + 1 - maxStackHeights.stackCount) > 0) {
            maxStackHeights.addStackCount(overflow);
        }
    }

    private String getDescriptor() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        int nParams = this.paramTypes.size();
        for (int i = 0; i < nParams; ++i) {
            buffer.append(this.paramTypes.get(i).getInternalName(true, true));
        }
        buffer.append(")V");
        return buffer.toString();
    }

    @Override
    public void writeTo(StringWriter stringWriter) {
        stringWriter.write("throw ");
        if (this.type == null || Type.UNDEFINED == this.type) {
            stringWriter.write(this.typeName);
        } else {
            stringWriter.write(this.type.getName());
        }
        String separator = "";
        stringWriter.write("(");
        for (Expression argument : this.arguments) {
            stringWriter.write(separator);
            argument.writeTo(stringWriter);
            separator = ",";
        }
        stringWriter.write(")");
    }
}

