/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.helper;

import java.util.HashMap;
import java.util.Iterator;
import org.jboss.byteman.agent.Transformer;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.binding.Binding;
import org.jboss.byteman.rule.binding.Bindings;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.helper.Helper;
import org.jboss.byteman.rule.helper.HelperAdapter;

public class InterpretedHelper
extends Helper
implements HelperAdapter {
    protected HashMap<String, Object> bindingMap = new HashMap();

    public InterpretedHelper(Rule rule) {
        super(rule);
    }

    @Override
    public void execute(Object recipient, Object[] args) throws ExecuteException {
        String name;
        Binding binding;
        if (Transformer.isVerbose()) {
            System.out.println(this.rule.getName() + " execute");
        }
        Bindings bindings = this.rule.getBindings();
        Iterator<Binding> iterator = bindings.iterator();
        while (iterator.hasNext()) {
            binding = iterator.next();
            name = binding.getName();
            if (binding.isAlias()) {
                binding = binding.getAlias();
            }
            if (binding.isHelper()) {
                this.bindingMap.put(name, this);
                continue;
            }
            if (binding.isRecipient()) {
                this.bindingMap.put(name, recipient);
                continue;
            }
            if (binding.isBindVar()) continue;
            this.bindingMap.put(name, args[binding.getCallArrayIndex()]);
        }
        this.execute0();
        iterator = bindings.iterator();
        while (iterator.hasNext()) {
            binding = iterator.next();
            name = binding.getName();
            if (binding.isAlias()) {
                binding = binding.getAlias();
            }
            if (!binding.isUpdated() || binding.isBindVar()) continue;
            Object value = this.bindingMap.get(name);
            int idx = binding.getCallArrayIndex();
            args[idx] = value;
        }
    }

    protected void execute0() throws ExecuteException {
        this.bind();
        if (this.test()) {
            this.fire();
        }
    }

    @Override
    public void setBinding(String name, Object value) {
        this.bindingMap.put(name, value);
    }

    @Override
    public Object getBinding(String name) {
        return this.bindingMap.get(name);
    }

    private void bind() throws ExecuteException {
        this.rule.getEvent().interpret(this);
    }

    private boolean test() throws ExecuteException {
        return (Boolean)this.rule.getCondition().interpret(this);
    }

    private void fire() throws ExecuteException {
        this.rule.getAction().interpret(this);
    }

    @Override
    public String getName() {
        return this.rule.getName();
    }
}

