/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.byteman.agent.Transformer;
import org.jboss.byteman.rule.Rule;

public class HelperManager {
    private Instrumentation inst;
    private ConcurrentHashMap<Class<?>, LifecycleDetails> helperDetailsMap;
    private static final String ACTIVATED_NAME = "activated";
    private static final String DEACTIVATED_NAME = "deactivated";
    private static final String INSTALLED_NAME = "installed";
    private static final String UNINSTALLED_NAME = "uninstalled";
    private static final Class[] ACTIVATED_SIGNATURE = null;
    private static final Class[] DEACTIVATED_SIGNATURE = null;
    private static final Class[] INSTALLED_RULE_SIGNATURE = new Class[]{Rule.class};
    private static final Class[] UNINSTALLED_RULE_SIGNATURE = INSTALLED_RULE_SIGNATURE;
    private static final Class[] INSTALLED_STRING_SIGNATURE = new Class[]{String.class};
    private static final Class[] UNINSTALLED_STRING_SIGNATURE = INSTALLED_STRING_SIGNATURE;

    public HelperManager(Instrumentation inst) {
        this.inst = inst;
        this.helperDetailsMap = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installed(Rule rule) {
        Class helperClass = rule.getHelperClass();
        if (Transformer.isVerbose()) {
            System.out.println("HelperManager.install for helper class" + helperClass.getName());
        }
        Class clazz = helperClass;
        synchronized (clazz) {
            LifecycleDetails details = this.getDetails(helperClass, true);
            if (details.installCount == 0 && details.activated != null) {
                if (Transformer.isVerbose()) {
                    System.out.println("calling activated() for helper class" + helperClass.getName());
                }
                try {
                    details.activated.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    System.out.println("HelperManager.installed : unexpected exception from " + helperClass.getName() + ".activate() : " + e);
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    System.out.println("HelperManager.installed : unexpected exception from " + helperClass.getName() + ".activate() : " + e);
                    e.printStackTrace();
                }
            }
            if (details.installed != null) {
                if (Transformer.isVerbose()) {
                    System.out.println("calling installed(" + rule.getName() + ") for helper class" + helperClass.getName());
                }
                try {
                    if (details.installedTakesRule) {
                        details.installed.invoke(null, rule);
                    } else {
                        details.installed.invoke(null, rule.getName());
                    }
                }
                catch (IllegalAccessException e) {
                    System.out.println("HelperManager.installed : unexpected exception from " + helperClass.getName() + ".installed(String) : " + e);
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    System.out.println("HelperManager.installed : unexpected exception from " + helperClass.getName() + ".installed(String) : " + e);
                    e.printStackTrace();
                }
            }
            ++details.installCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstalled(Rule rule) {
        Class helperClass = rule.getHelperClass();
        if (Transformer.isVerbose()) {
            System.out.println("HelperManager.uninstall for helper class" + helperClass.getName());
        }
        Class clazz = helperClass;
        synchronized (clazz) {
            LifecycleDetails details = this.getDetails(helperClass, false);
            if (details == null) {
                System.out.println("HelperManager.uninstalled : shouldn't happen! uninstall failed to locate helper details for " + helperClass.getName());
                return;
            }
            --details.installCount;
            if (details.uninstalled != null) {
                if (Transformer.isVerbose()) {
                    System.out.println("calling uninstalled(" + rule.getName() + ") for helper class" + helperClass.getName());
                }
                try {
                    if (details.uninstalledTakesRule) {
                        details.uninstalled.invoke(null, rule);
                    } else {
                        details.uninstalled.invoke(null, rule.getName());
                    }
                }
                catch (IllegalAccessException e) {
                    System.out.println("HelperManager.installed : unexpected exception from " + helperClass.getName() + ".uninstalled(String) : " + e);
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    System.out.println("HelperManager.installed : unexpected exception from " + helperClass.getName() + ".uninstalled(String) : " + e);
                    e.printStackTrace();
                }
            }
            if (details.installCount == 0 && details.deactivated != null) {
                if (Transformer.isVerbose()) {
                    System.out.println("calling deactivated() for helper class" + helperClass.getName());
                }
                try {
                    details.deactivated.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    System.out.println("HelperManager.uninstalled : unexpected exception from " + helperClass.getName() + ".deactivate() : " + e);
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    System.out.println("HelperManager.installed : unexpected exception from " + helperClass.getName() + ".deactivate() : " + e);
                    e.printStackTrace();
                }
            }
            if (details.installCount == 0) {
                this.purgeDetails(details);
            }
        }
    }

    private LifecycleDetails getDetails(Class<?> helperClass, boolean createIfAbsent) {
        LifecycleDetails details = this.helperDetailsMap.get(helperClass);
        if (details == null && createIfAbsent) {
            details = new LifecycleDetails(helperClass);
            details.activated = this.lookupLifecycleMethod(helperClass, ACTIVATED_NAME, ACTIVATED_SIGNATURE);
            details.deactivated = this.lookupLifecycleMethod(helperClass, DEACTIVATED_NAME, DEACTIVATED_SIGNATURE);
            details.installed = this.lookupLifecycleMethod(helperClass, INSTALLED_NAME, INSTALLED_RULE_SIGNATURE);
            details.uninstalled = this.lookupLifecycleMethod(helperClass, UNINSTALLED_NAME, UNINSTALLED_RULE_SIGNATURE);
            if (details.installed != null) {
                details.installedTakesRule = true;
            } else {
                details.installed = this.lookupLifecycleMethod(helperClass, INSTALLED_NAME, INSTALLED_STRING_SIGNATURE);
            }
            if (details.uninstalled != null) {
                details.uninstalledTakesRule = true;
            } else {
                details.uninstalled = this.lookupLifecycleMethod(helperClass, UNINSTALLED_NAME, UNINSTALLED_STRING_SIGNATURE);
            }
            this.helperDetailsMap.put(helperClass, details);
        }
        return details;
    }

    private Method lookupLifecycleMethod(Class<?> clazz, String name, Class<?>[] paramTypes) {
        try {
            Method m = clazz.getMethod(name, paramTypes);
            int mod = m.getModifiers();
            if (Modifier.isStatic(mod)) {
                return m;
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return null;
    }

    private void purgeDetails(LifecycleDetails details) {
        this.helperDetailsMap.remove(details.lifecycleClass);
    }

    private static class LifecycleDetails {
        public Class<?> lifecycleClass;
        public int installCount;
        public Method activated;
        public Method deactivated;
        public Method installed;
        public boolean installedTakesRule;
        public Method uninstalled;
        public boolean uninstalledTakesRule;

        public LifecycleDetails(Class<?> lifecycleClass) {
            this.lifecycleClass = lifecycleClass;
            this.installCount = 0;
        }
    }
}

