/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent;

import java.io.PrintWriter;
import java.lang.instrument.Instrumentation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import org.jboss.byteman.agent.RuleScript;
import org.jboss.byteman.agent.ScriptRepository;
import org.jboss.byteman.agent.Transform;
import org.jboss.byteman.agent.TransformListener;
import org.jboss.byteman.agent.Transformer;

public class Retransformer
extends Transformer {
    private Set<String> sysJars = new HashSet<String>();
    private Set<String> bootJars = new HashSet<String>();

    public Retransformer(Instrumentation inst, List<String> scriptPaths, List<String> scriptTexts, boolean isRedefine) throws Exception {
        super(inst, scriptPaths, scriptTexts, isRedefine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installScript(List<String> scriptTexts, List<String> scriptNames, PrintWriter out) throws Exception {
        int length = scriptTexts.size();
        LinkedList<RuleScript> toBeAdded = new LinkedList<RuleScript>();
        LinkedList<RuleScript> toBeRemoved = new LinkedList<RuleScript>();
        for (int i = 0; i < length; ++i) {
            String scriptText = scriptTexts.get(i);
            String scriptName = scriptNames.get(i);
            List<RuleScript> ruleScripts = this.scriptRepository.processScripts(scriptText, scriptName);
            toBeAdded.addAll(ruleScripts);
        }
        for (RuleScript ruleScript : toBeAdded) {
            RuleScript previous;
            String name = ruleScript.getName();
            String className = ruleScript.getTargetClass();
            String baseName = null;
            int lastDotIdx = className.lastIndexOf(46);
            if (lastDotIdx >= 0) {
                baseName = className.substring(lastDotIdx + 1);
            }
            if ((previous = this.scriptRepository.addScript(ruleScript)) != null) {
                out.println("redefine rule " + name);
                toBeRemoved.add(previous);
                continue;
            }
            out.println("install rule " + name);
        }
        LinkedList<String> deletedClassNames = new LinkedList<String>();
        for (RuleScript ruleScript : toBeRemoved) {
            List<Transform> transforms = ruleScript.getTransformed();
            for (Transform transform : transforms) {
                String className = transform.getInternalClassName();
                if (deletedClassNames.contains(className)) continue;
                deletedClassNames.add(className);
            }
        }
        ScriptRepository tmpRepository = new ScriptRepository(Retransformer.skipOverrideRules());
        for (RuleScript ruleScript : toBeAdded) {
            tmpRepository.addScript(ruleScript);
        }
        LinkedList<Class> transformed = new LinkedList<Class>();
        for (Class clazz : this.inst.getAllLoadedClasses()) {
            if (this.isSkipClass(clazz)) continue;
            if (deletedClassNames.contains(clazz.getName())) {
                transformed.add(clazz);
                continue;
            }
            if (!tmpRepository.matchClass(clazz)) continue;
            transformed.add(clazz);
        }
        if (!transformed.isEmpty()) {
            Class[] transformedArray = new Class[transformed.size()];
            transformed.toArray(transformedArray);
            if (Transformer.isVerbose()) {
                for (int i = 0; i < transformed.size(); ++i) {
                    System.out.println("retransforming " + transformedArray[i].getName());
                }
            }
            Retransformer i = this;
            synchronized (i) {
                this.inst.retransformClasses(transformedArray);
            }
        }
        for (RuleScript ruleScript : toBeRemoved) {
            ruleScript.purge();
        }
    }

    protected void collectAffectedNames(List<RuleScript> ruleScripts, List<String> classList, List<String> interfaceList, List<String> superClassList, List<String> superInterfaceList) {
        for (RuleScript ruleScript : ruleScripts) {
            String targetClassName = ruleScript.getTargetClass();
            boolean isOverride = ruleScript.isOverride();
            if (ruleScript.isInterface()) {
                if (interfaceList.contains(targetClassName)) continue;
                interfaceList.add(targetClassName);
                if (!isOverride) continue;
                superInterfaceList.add(targetClassName);
                continue;
            }
            if (classList.contains(targetClassName)) continue;
            classList.add(targetClassName);
            if (!isOverride) continue;
            superClassList.add(targetClassName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void listScripts(PrintWriter out) throws Exception {
        Iterator<RuleScript> iterator = this.scriptRepository.currentRules().iterator();
        if (!iterator.hasNext()) {
            out.println("no rules installed");
        } else {
            while (iterator.hasNext()) {
                RuleScript ruleScript = iterator.next();
                ruleScript.writeTo(out);
                RuleScript ruleScript2 = ruleScript;
                synchronized (ruleScript2) {
                    List<Transform> transformed = ruleScript.getTransformed();
                    if (transformed != null) {
                        for (Transform transform : transformed) {
                            transform.writeTo(out);
                        }
                    }
                }
            }
        }
    }

    public void addTransformListener(String hostname, Integer port) {
        TransformListener.initialize(this, hostname, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void removeScripts(List<String> scriptTexts, PrintWriter out) throws Exception {
        List<Object> toBeRemoved;
        if (scriptTexts != null) {
            void var5_7;
            toBeRemoved = new LinkedList();
            int length = scriptTexts.size();
            boolean bl = false;
            while (var5_7 < length) {
                String scriptText = scriptTexts.get((int)var5_7);
                String[] stringArray = scriptText.split("\n");
                for (int j = 0; j < stringArray.length; ++j) {
                    String line = stringArray[j].trim();
                    if (!line.startsWith("RULE ")) continue;
                    String name = line.substring(5).trim();
                    RuleScript ruleScript = this.scriptRepository.scriptForRuleName(name);
                    if (ruleScript == null) {
                        out.print("ERROR failed to find loaded rule with name ");
                        out.println(name);
                        continue;
                    }
                    if (toBeRemoved.contains(ruleScript)) {
                        out.print("WARNING duplicate occurence for rule name ");
                        out.println(name);
                        continue;
                    }
                    toBeRemoved.add(ruleScript);
                }
                ++var5_7;
            }
        } else {
            toBeRemoved = this.scriptRepository.currentRules();
        }
        if (toBeRemoved.isEmpty()) {
            out.println("ERROR No rule scripts to remove");
            return;
        }
        for (RuleScript ruleScript : toBeRemoved) {
            if (this.scriptRepository.removeScript(ruleScript) == ruleScript) continue;
            out.println("ERROR remove failed to find script " + ruleScript.getName());
        }
        LinkedList<Class> transformed = new LinkedList<Class>();
        LinkedList<String> linkedList = new LinkedList<String>();
        for (RuleScript ruleScript : toBeRemoved) {
            List<Transform> transforms = ruleScript.getTransformed();
            if (transforms == null) continue;
            for (Transform transform : transforms) {
                String className = transform.getInternalClassName();
                if (linkedList.contains(className)) continue;
                linkedList.add(className);
            }
        }
        for (Class clazz : this.inst.getAllLoadedClasses()) {
            if (this.isSkipClass(clazz) || !linkedList.contains(clazz.getName())) continue;
            transformed.add(clazz);
        }
        if (!transformed.isEmpty()) {
            Class[] transformedArray = new Class[transformed.size()];
            transformed.toArray(transformedArray);
            if (Transformer.isVerbose()) {
                void var7_16;
                boolean bl = false;
                while (var7_16 < transformed.size()) {
                    System.out.println("retransforming " + transformedArray[var7_16].getName());
                    ++var7_16;
                }
            }
            Instrumentation instrumentation = this.inst;
            synchronized (instrumentation) {
                this.inst.retransformClasses(transformedArray);
            }
        }
        for (RuleScript ruleScript : toBeRemoved) {
            ruleScript.purge();
            out.println("uninstall RULE " + ruleScript.getName());
        }
    }

    public void appendJarFile(PrintWriter out, JarFile jarfile, boolean isBoot) throws Exception {
        if (isBoot) {
            this.inst.appendToBootstrapClassLoaderSearch(jarfile);
            this.bootJars.add(jarfile.getName());
            out.println("append boot jar " + jarfile.getName());
        } else {
            this.inst.appendToSystemClassLoaderSearch(jarfile);
            this.sysJars.add(jarfile.getName());
            out.println("append sys jar " + jarfile.getName());
        }
    }

    public Set<String> getLoadedBootJars() {
        return new HashSet<String>(this.bootJars);
    }

    public Set<String> getLoadedSystemJars() {
        return new HashSet<String>(this.sysJars);
    }
}

