/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent;

import java.util.HashMap;
import org.jboss.byteman.agent.HelperManager;
import org.jboss.byteman.agent.RuleScript;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.type.TypeHelper;

public class TransformContext {
    private RuleScript ruleScript;
    private String triggerClass;
    private String targetMethodName;
    private String targetDescriptor;
    private ClassLoader loader;
    HelperManager helperManager;
    private HashMap<String, Rule> ruleMap;

    public TransformContext(RuleScript ruleScript, String triggerClass, String targetMethodSpec, ClassLoader loader, HelperManager helperManager) {
        this.ruleScript = ruleScript;
        this.triggerClass = triggerClass;
        this.targetMethodName = TypeHelper.parseMethodName(targetMethodSpec);
        this.targetDescriptor = TypeHelper.parseMethodDescriptor(targetMethodSpec);
        this.loader = loader;
        this.ruleMap = new HashMap();
        this.helperManager = helperManager;
    }

    public void parseRule() throws Throwable {
        try {
            Rule rule = Rule.create(this.ruleScript, this.loader, this.helperManager);
            this.ruleMap.put(this.triggerClass, rule);
        }
        catch (Throwable th) {
            this.recordFailedTransform(th);
            throw th;
        }
    }

    public Rule getRule(String triggerMethodName, String triggerMethodDescriptor) {
        String key = this.getRuleKey(triggerMethodName, triggerMethodDescriptor);
        Rule rule = this.ruleMap.get(key);
        if (rule != null) {
            return rule;
        }
        rule = this.ruleMap.remove(this.triggerClass);
        if (rule == null) {
            try {
                rule = Rule.create(this.ruleScript, this.loader, this.helperManager);
            }
            catch (Throwable th) {
                // empty catch block
            }
        }
        this.ruleMap.put(key, rule);
        return rule;
    }

    public void recordFailedTransform(Throwable th) {
        this.ruleScript.recordFailedTransform(this.loader, this.triggerClass, th);
    }

    public void recordMethodTransform(String triggerMethodName, String triggerMethodDescriptor) {
        Rule rule = this.removeRule(triggerMethodName, triggerMethodDescriptor);
        this.ruleScript.recordMethodTransform(this.loader, this.triggerClass, triggerMethodName, triggerMethodDescriptor, rule);
    }

    public boolean matchTargetMethod(String name, String desc) {
        return this.targetMethodName.equals(name) && (this.targetDescriptor.equals("") || TypeHelper.equalDescriptors(this.targetDescriptor, desc));
    }

    public String getTriggerClass() {
        return this.triggerClass;
    }

    private Rule removeRule(String triggerMethodName, String triggerMethodDescriptor) {
        return this.ruleMap.remove(this.getRuleKey(triggerMethodName, triggerMethodDescriptor));
    }

    private String getRuleKey(String triggerMethodName, String triggerMethodDescriptor) {
        return this.triggerClass + "." + triggerMethodName + TypeHelper.internalizeDescriptor(triggerMethodDescriptor);
    }
}

