/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.adapter.RuleCheckAdapter;
import org.jboss.byteman.agent.adapter.RuleCheckMethodAdapter;
import org.jboss.byteman.org.objectweb.asm.ClassVisitor;
import org.jboss.byteman.org.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.type.TypeHelper;

public class AccessCheckAdapter
extends RuleCheckAdapter {
    private String ownerClass;
    private String fieldName;
    private int flags;
    private int count;
    private int visitedCount;

    public AccessCheckAdapter(ClassVisitor cv, TransformContext transformContext, String ownerClass, String fieldName, int flags, int count) {
        super(cv, transformContext);
        this.ownerClass = ownerClass;
        this.fieldName = fieldName;
        this.flags = flags;
        this.count = count;
        this.visitedCount = 0;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ((access & 0x1500) == 0 && this.matchTargetMethod(name, desc)) {
            this.setVisited();
            return new AccessCheckMethodAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
        }
        return mv;
    }

    private class AccessCheckMethodAdapter
    extends RuleCheckMethodAdapter {
        private int access;
        private String name;
        private String descriptor;
        private String signature;
        private String[] exceptions;
        private boolean visited;

        AccessCheckMethodAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor);
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
            this.signature = signature;
            this.exceptions = exceptions;
            AccessCheckAdapter.this.visitedCount = 0;
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if ((AccessCheckAdapter.this.count == 0 || AccessCheckAdapter.this.visitedCount < AccessCheckAdapter.this.count) && this.matchCall(opcode, owner, name, desc)) {
                AccessCheckAdapter.this.visitedCount++;
                if (AccessCheckAdapter.this.count == 0 || AccessCheckAdapter.this.visitedCount == AccessCheckAdapter.this.count) {
                    this.setTriggerPoint();
                }
            }
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        @Override
        public void visitEnd() {
            if (this.checkBindings()) {
                AccessCheckAdapter.this.setVisitOk();
            }
            super.visitEnd();
        }

        private boolean matchCall(int opcode, String owner, String name, String desc) {
            if (!AccessCheckAdapter.this.fieldName.equals(name)) {
                return false;
            }
            switch (opcode) {
                case 178: 
                case 180: {
                    if ((AccessCheckAdapter.this.flags & 1) != 0) break;
                    return false;
                }
                case 179: 
                case 181: {
                    if ((AccessCheckAdapter.this.flags & 2) != 0) break;
                    return false;
                }
            }
            if (AccessCheckAdapter.this.ownerClass != null && !AccessCheckAdapter.this.ownerClass.equals(TypeHelper.internalizeClass(owner))) {
                if (AccessCheckAdapter.this.ownerClass.indexOf(46) >= 0) {
                    return false;
                }
                int ownerPackageIdx = owner.lastIndexOf(47);
                if (ownerPackageIdx < 0) {
                    return false;
                }
                if (!owner.substring(ownerPackageIdx + 1).equals(AccessCheckAdapter.this.ownerClass)) {
                    return false;
                }
            }
            return true;
        }
    }
}

