/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.org.objectweb.asm.Label;
import org.jboss.byteman.org.objectweb.asm.MethodAdapter;
import org.jboss.byteman.org.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;

public class RuleMethodAdapter
extends MethodAdapter {
    HashMap<String, LinkedList<LocalVar>> localVarsByName = new HashMap();
    protected TransformContext transformContext;
    protected Rule rule;
    protected int access;
    protected String name;
    protected String descriptor;

    public RuleMethodAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String desc) {
        super(mv);
        this.access = access;
        this.name = name;
        this.descriptor = desc;
        this.transformContext = transformContext;
        this.rule = transformContext.getRule(name, desc);
    }

    public String getTriggerClass() {
        return this.transformContext.getTriggerClass();
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        super.visitLocalVariable(name, desc, signature, start, end, index);
        LocalVar localVar = new LocalVar(name, desc, signature, start, end, index);
        LinkedList<LocalVar> locals = this.localVarsByName.get(name);
        if (locals == null) {
            locals = new LinkedList();
            this.localVarsByName.put(name, locals);
        }
        locals.addFirst(localVar);
    }

    protected List<LocalVar> lookup(String name) {
        return this.localVarsByName.get(name);
    }

    protected static class LocalVar {
        public String name;
        public String desc;
        public String signature;
        public Label start;
        public Label end;
        public int index;

        public LocalVar(String name, String desc, String signature, Label start, Label end, int index) {
            this.name = name;
            this.desc = desc;
            this.signature = signature;
            this.start = start;
            this.end = end;
            this.index = index;
        }
    }
}

