/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.adapter.RuleTriggerAdapter;
import org.jboss.byteman.agent.adapter.RuleTriggerMethodAdapter;
import org.jboss.byteman.org.objectweb.asm.ClassVisitor;
import org.jboss.byteman.org.objectweb.asm.MethodVisitor;

public class SynchronizeTriggerAdapter
extends RuleTriggerAdapter {
    private int count;
    private boolean whenComplete;

    public SynchronizeTriggerAdapter(ClassVisitor cv, TransformContext transformContext, int count, boolean whenComplete) {
        super(cv, transformContext);
        this.count = count;
        this.whenComplete = whenComplete;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.matchTargetMethod(name, desc)) {
            return new SynchronizeTriggerMethodAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
        }
        return mv;
    }

    private class SynchronizeTriggerMethodAdapter
    extends RuleTriggerMethodAdapter {
        private int visitedCount;

        SynchronizeTriggerMethodAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor, signature, exceptions);
            this.visitedCount = 0;
        }

        @Override
        public void visitInsn(int opcode) {
            if (SynchronizeTriggerAdapter.this.whenComplete) {
                super.visitInsn(opcode);
            }
            if (opcode == 194 && (SynchronizeTriggerAdapter.this.count == 0 || this.visitedCount < SynchronizeTriggerAdapter.this.count)) {
                ++this.visitedCount;
                if (SynchronizeTriggerAdapter.this.count == 0 || this.visitedCount == SynchronizeTriggerAdapter.this.count) {
                    this.injectTriggerPoint();
                }
            }
            if (!SynchronizeTriggerAdapter.this.whenComplete) {
                super.visitInsn(opcode);
            }
        }
    }
}

