/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import org.jboss.byteman.org.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.StackHeights;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.BinaryOperExpression;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class ArithmeticExpression
extends BinaryOperExpression {
    public ArithmeticExpression(Rule rule, int oper, ParseNode token, Expression left, Expression right) throws TypeException {
        super(rule, oper, Type.promote(left.getType(), right.getType()), token, left, right);
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        Type type1 = this.getOperand(0).typeCheck(Type.N);
        Type type2 = this.getOperand(1).typeCheck(Type.N);
        this.type = Type.promote(type1, type2);
        if (Type.dereference(expected).isDefined() && !expected.isAssignableFrom(this.type)) {
            throw new TypeException("ArithmenticExpression.typeCheck : invalid expected result type " + expected.getName() + this.getPos());
        }
        return this.type;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        try {
            char result;
            Object objValue1 = this.getOperand(0).interpret(helper);
            Object objValue2 = this.getOperand(1).interpret(helper);
            Number value1 = objValue1 instanceof Character ? (Number)new Integer(((Character)objValue1).charValue()) : (Number)((Number)objValue1);
            Number value2 = objValue2 instanceof Character ? (Number)new Integer(((Character)objValue2).charValue()) : (Number)((Number)objValue2);
            if (this.type == Type.B) {
                byte result2;
                byte b1 = value1.byteValue();
                byte b2 = value2.byteValue();
                switch (this.oper) {
                    case 8705: {
                        result2 = (byte)(b1 * b2);
                        break;
                    }
                    case 8706: {
                        result2 = (byte)(b1 / b2);
                        break;
                    }
                    case 8707: {
                        result2 = (byte)(b1 + b2);
                        break;
                    }
                    case 8708: {
                        result2 = (byte)(b1 - b2);
                        break;
                    }
                    case 8709: {
                        result2 = (byte)(b1 % b2);
                        break;
                    }
                    default: {
                        result2 = 0;
                    }
                }
                return new Byte(result2);
            }
            if (this.type == Type.S) {
                short result3;
                short s1 = value1.shortValue();
                short s2 = value2.shortValue();
                switch (this.oper) {
                    case 8705: {
                        result3 = (short)(s1 * s2);
                        break;
                    }
                    case 8706: {
                        result3 = (short)(s1 / s2);
                        break;
                    }
                    case 8707: {
                        result3 = (short)(s1 + s2);
                        break;
                    }
                    case 8708: {
                        result3 = (short)(s1 - s2);
                        break;
                    }
                    case 8709: {
                        result3 = (short)(s1 % s2);
                        break;
                    }
                    default: {
                        result3 = 0;
                    }
                }
                return new Short(result3);
            }
            if (this.type == Type.I) {
                int result4;
                int i1 = value1.intValue();
                int i2 = value2.intValue();
                switch (this.oper) {
                    case 8705: {
                        result4 = i1 * i2;
                        break;
                    }
                    case 8706: {
                        result4 = i1 / i2;
                        break;
                    }
                    case 8707: {
                        result4 = i1 + i2;
                        break;
                    }
                    case 8708: {
                        result4 = i1 - i2;
                        break;
                    }
                    case 8709: {
                        result4 = i1 % i2;
                        break;
                    }
                    default: {
                        result4 = 0;
                    }
                }
                return new Integer(result4);
            }
            if (this.type == Type.J) {
                long result5;
                long l1 = value1.longValue();
                long l2 = value2.longValue();
                switch (this.oper) {
                    case 8705: {
                        result5 = l1 * l2;
                        break;
                    }
                    case 8706: {
                        result5 = l1 / l2;
                        break;
                    }
                    case 8707: {
                        result5 = l1 + l2;
                        break;
                    }
                    case 8708: {
                        result5 = l1 - l2;
                        break;
                    }
                    case 8709: {
                        result5 = l1 % l2;
                        break;
                    }
                    default: {
                        result5 = 0L;
                    }
                }
                return new Long(result5);
            }
            if (this.type == Type.F) {
                float result6;
                float f1 = value1.floatValue();
                float f2 = value2.floatValue();
                switch (this.oper) {
                    case 8705: {
                        result6 = f1 * f2;
                        break;
                    }
                    case 8706: {
                        result6 = f1 / f2;
                        break;
                    }
                    case 8707: {
                        result6 = f1 + f2;
                        break;
                    }
                    case 8708: {
                        result6 = f1 - f2;
                        break;
                    }
                    case 8709: {
                        result6 = f1 % f2;
                        break;
                    }
                    default: {
                        result6 = 0.0f;
                    }
                }
                return new Float(result6);
            }
            if (this.type == Type.D) {
                double result7;
                double d1 = value1.doubleValue();
                double d2 = value2.doubleValue();
                switch (this.oper) {
                    case 8705: {
                        result7 = d1 * d2;
                        break;
                    }
                    case 8706: {
                        result7 = d1 / d2;
                        break;
                    }
                    case 8707: {
                        result7 = d1 + d2;
                        break;
                    }
                    case 8708: {
                        result7 = d1 - d2;
                        break;
                    }
                    case 8709: {
                        result7 = d1 % d2;
                        break;
                    }
                    default: {
                        result7 = 0.0;
                    }
                }
                return new Double(result7);
            }
            int s1 = value1.intValue();
            int s2 = value2.intValue();
            switch (this.oper) {
                case 8705: {
                    result = (char)(s1 * s2);
                    break;
                }
                case 8706: {
                    result = (char)(s1 / s2);
                    break;
                }
                case 8707: {
                    result = (char)(s1 + s2);
                    break;
                }
                case 8708: {
                    result = (char)(s1 - s2);
                    break;
                }
                case 8709: {
                    result = (char)(s1 % s2);
                    break;
                }
                default: {
                    result = '\u0000';
                }
            }
            return new Integer(result);
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecuteException("ArithmeticExpression.interpret : unexpected exception for operation " + this.token + this.getPos() + " in rule " + helper.getName(), e);
        }
    }

    @Override
    public void compile(MethodVisitor mv, StackHeights currentStackHeights, StackHeights maxStackHeights) throws CompileException {
        int expectedStack;
        int currentStack;
        block43: {
            currentStack = currentStackHeights.stackCount;
            expectedStack = 0;
            Expression operand0 = this.getOperand(0);
            Expression operand1 = this.getOperand(1);
            Type type0 = operand0.getType();
            Type type1 = operand1.getType();
            operand0.compile(mv, currentStackHeights, maxStackHeights);
            this.compileTypeConversion(type0, this.type, mv, currentStackHeights, maxStackHeights);
            operand1.compile(mv, currentStackHeights, maxStackHeights);
            this.compileTypeConversion(type1, this.type, mv, currentStackHeights, maxStackHeights);
            try {
                block45: {
                    block44: {
                        if (this.type == Type.B) break block44;
                        if (this.type == Type.S) break block44;
                        if (this.type == Type.C) break block44;
                        if (this.type != Type.I) break block45;
                    }
                    expectedStack = 1;
                    switch (this.oper) {
                        case 8705: {
                            mv.visitInsn(104);
                            break;
                        }
                        case 8706: {
                            mv.visitInsn(108);
                            break;
                        }
                        case 8707: {
                            mv.visitInsn(96);
                            break;
                        }
                        case 8708: {
                            mv.visitInsn(100);
                            break;
                        }
                        case 8709: {
                            mv.visitInsn(112);
                            break;
                        }
                        default: {
                            throw new CompileException("ArithmeticExpression.compile : unexpected operator " + this.oper);
                        }
                    }
                    if (this.type == Type.B) {
                        mv.visitInsn(145);
                    } else if (this.type == Type.S) {
                        mv.visitInsn(147);
                    } else if (this.type == Type.C) {
                        mv.visitInsn(146);
                    }
                    currentStackHeights.addStackCount(-1);
                    break block43;
                }
                if (this.type == Type.J) {
                    expectedStack = 2;
                    switch (this.oper) {
                        case 8705: {
                            mv.visitInsn(105);
                            break;
                        }
                        case 8706: {
                            mv.visitInsn(109);
                            break;
                        }
                        case 8707: {
                            mv.visitInsn(97);
                            break;
                        }
                        case 8708: {
                            mv.visitInsn(101);
                            break;
                        }
                        case 8709: {
                            mv.visitInsn(113);
                            break;
                        }
                        default: {
                            throw new CompileException("ArithmeticExpression.compile : unexpected operator " + this.oper);
                        }
                    }
                    currentStackHeights.addStackCount(-2);
                    break block43;
                }
                if (this.type == Type.F) {
                    expectedStack = 1;
                    switch (this.oper) {
                        case 8705: {
                            mv.visitInsn(106);
                            break;
                        }
                        case 8706: {
                            mv.visitInsn(110);
                            break;
                        }
                        case 8707: {
                            mv.visitInsn(98);
                            break;
                        }
                        case 8708: {
                            mv.visitInsn(102);
                            break;
                        }
                        case 8709: {
                            mv.visitInsn(114);
                            break;
                        }
                        default: {
                            throw new CompileException("ArithmeticExpression.compile : unexpected operator " + this.oper);
                        }
                    }
                    currentStackHeights.addStackCount(-1);
                    break block43;
                }
                if (this.type == Type.D) {
                    expectedStack = 2;
                    switch (this.oper) {
                        case 8705: {
                            mv.visitInsn(107);
                            break;
                        }
                        case 8706: {
                            mv.visitInsn(111);
                            break;
                        }
                        case 8707: {
                            mv.visitInsn(99);
                            break;
                        }
                        case 8708: {
                            mv.visitInsn(103);
                            break;
                        }
                        case 8709: {
                            mv.visitInsn(115);
                            break;
                        }
                        default: {
                            throw new CompileException("ArithmeticExpression.compile : unexpected operator " + this.oper);
                        }
                    }
                    currentStackHeights.addStackCount(-2);
                    break block43;
                }
                throw new CompileException("ArithmeticExpression.compile : unexpected result type " + this.type.getName());
            }
            catch (CompileException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompileException("ArithmeticExpression.compile : unexpected exception for operation " + this.token + this.getPos() + " in rule " + this.rule.getName(), e);
            }
        }
        if (currentStackHeights.stackCount != currentStack + expectedStack) {
            throw new CompileException("ArithmeticExpression.compile : invalid stack height " + currentStackHeights.stackCount + " expecting " + (currentStack + expectedStack));
        }
        int maxStack = maxStackHeights.stackCount;
        int overflow = currentStack + 2 * expectedStack - maxStack;
        if (overflow > 0) {
            maxStackHeights.addStackCount(overflow);
        }
    }
}

