/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import java.io.StringWriter;
import org.jboss.byteman.org.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.StackHeights;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class BooleanLiteral
extends Expression {
    private boolean value;

    public BooleanLiteral(Rule rule, ParseNode token) {
        super(rule, Type.Z, token);
        this.value = (Boolean)token.getChild(0);
    }

    @Override
    public void bind() {
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        this.type = Type.Z;
        if (Type.dereference(expected).isDefined() && !expected.isAssignableFrom(this.type)) {
            throw new TypeException("BooleanLiteral.typeCheck : invalid expected result type " + expected.getName() + this.getPos());
        }
        return this.type;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        return this.value;
    }

    @Override
    public void compile(MethodVisitor mv, StackHeights currentStackHeights, StackHeights maxStackHeights) throws CompileException {
        mv.visitLdcInsn(this.value);
        currentStackHeights.addStackCount(1);
        if (currentStackHeights.stackCount > maxStackHeights.stackCount) {
            maxStackHeights.stackCount = currentStackHeights.stackCount;
        }
    }

    @Override
    public void writeTo(StringWriter stringWriter) {
        if (this.value) {
            stringWriter.write("TRUE");
        } else {
            stringWriter.write("FALSE");
        }
    }
}

