/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import org.jboss.byteman.org.objectweb.asm.Label;
import org.jboss.byteman.org.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.StackHeights;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.BooleanExpression;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class ComparisonExpression
extends BooleanExpression {
    private Type comparisonType = Type.UNDEFINED;
    private boolean comparable = false;

    public ComparisonExpression(Rule rule, int oper, ParseNode token, Expression left, Expression right) {
        super(rule, oper, token, left, right);
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        Type type1 = this.getOperand(0).typeCheck(Type.UNDEFINED);
        Type type2 = this.getOperand(1).typeCheck(Type.UNDEFINED);
        if (type1.isNumeric() || type2.isNumeric()) {
            this.comparisonType = Type.promote(type1, type2);
            this.comparable = true;
        } else if (type1.isAssignableFrom(type2)) {
            this.comparisonType = type1;
            this.comparable = Comparable.class.isAssignableFrom(this.comparisonType.getTargetClass());
        } else if (type2.isAssignableFrom(type1)) {
            this.comparisonType = type2;
            this.comparable = Comparable.class.isAssignableFrom(this.comparisonType.getTargetClass());
        } else {
            throw new TypeException("ComparisonExpression.typeCheck : incomparable argument types " + type1.getName() + " and " + type2.getName() + " for comparison expression" + this.getPos());
        }
        if (this.oper != 8320 && this.oper != 8321 && !this.comparable) {
            throw new TypeException("ComparisonExpression.typeCheck : cannot compare instances of class " + this.comparisonType.getName() + this.getPos());
        }
        this.type = Type.Z;
        if (Type.dereference(expected).isDefined() && !expected.isAssignableFrom(this.type)) {
            throw new TypeException("ComparisonExpression.typeCheck : invalid expected result type " + expected.getName() + this.getPos());
        }
        return this.type;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        try {
            block58: {
                boolean result;
                Number value2;
                Number value1;
                block60: {
                    boolean result2;
                    block59: {
                        if (!this.comparisonType.isNumeric()) break block58;
                        value1 = (Number)this.getOperand(0).interpret(helper);
                        value2 = (Number)this.getOperand(1).interpret(helper);
                        if (this.comparisonType == Type.B) break block59;
                        if (this.comparisonType == Type.S) break block59;
                        if (this.comparisonType != Type.I) break block60;
                    }
                    int i1 = value1.intValue();
                    int i2 = value2.intValue();
                    switch (this.oper) {
                        case 8323: {
                            result2 = i1 < i2;
                            break;
                        }
                        case 8325: {
                            result2 = i1 <= i2;
                            break;
                        }
                        case 8322: {
                            result2 = i1 > i2;
                            break;
                        }
                        case 8324: {
                            result2 = i1 >= i2;
                            break;
                        }
                        case 8320: {
                            result2 = i1 == i2;
                            break;
                        }
                        case 8321: {
                            result2 = i1 != i2;
                            break;
                        }
                        default: {
                            result2 = false;
                        }
                    }
                    return result2;
                }
                if (this.comparisonType == Type.J) {
                    boolean result3;
                    long l1 = value1.longValue();
                    long l2 = value2.longValue();
                    switch (this.oper) {
                        case 8323: {
                            result3 = l1 < l2;
                            break;
                        }
                        case 8325: {
                            result3 = l1 <= l2;
                            break;
                        }
                        case 8322: {
                            result3 = l1 > l2;
                            break;
                        }
                        case 8324: {
                            result3 = l1 >= l2;
                            break;
                        }
                        case 8320: {
                            result3 = l1 == l2;
                            break;
                        }
                        case 8321: {
                            result3 = l1 != l2;
                            break;
                        }
                        default: {
                            result3 = false;
                        }
                    }
                    return result3;
                }
                if (this.comparisonType == Type.F) {
                    boolean result4;
                    float f1 = value1.floatValue();
                    float f2 = value2.floatValue();
                    switch (this.oper) {
                        case 8323: {
                            result4 = f1 < f2;
                            break;
                        }
                        case 8325: {
                            result4 = f1 <= f2;
                            break;
                        }
                        case 8322: {
                            result4 = f1 > f2;
                            break;
                        }
                        case 8324: {
                            result4 = f1 >= f2;
                            break;
                        }
                        case 8320: {
                            result4 = f1 == f2;
                            break;
                        }
                        case 8321: {
                            result4 = f1 != f2;
                            break;
                        }
                        default: {
                            result4 = false;
                        }
                    }
                    return result4;
                }
                if (this.comparisonType == Type.D) {
                    boolean result5;
                    double d1 = value1.doubleValue();
                    double d2 = value2.doubleValue();
                    switch (this.oper) {
                        case 8323: {
                            result5 = d1 < d2;
                            break;
                        }
                        case 8325: {
                            result5 = d1 <= d2;
                            break;
                        }
                        case 8322: {
                            result5 = d1 > d2;
                            break;
                        }
                        case 8324: {
                            result5 = d1 >= d2;
                            break;
                        }
                        case 8320: {
                            result5 = d1 == d2;
                            break;
                        }
                        case 8321: {
                            result5 = d1 != d2;
                            break;
                        }
                        default: {
                            result5 = false;
                        }
                    }
                    return result5;
                }
                char c1 = (char)value1.intValue();
                char c2 = (char)value2.intValue();
                switch (this.oper) {
                    case 8323: {
                        result = c1 < c2;
                        break;
                    }
                    case 8325: {
                        result = c1 <= c2;
                        break;
                    }
                    case 8322: {
                        result = c1 > c2;
                        break;
                    }
                    case 8324: {
                        result = c1 >= c2;
                        break;
                    }
                    case 8320: {
                        result = c1 == c2;
                        break;
                    }
                    case 8321: {
                        result = c1 != c2;
                        break;
                    }
                    default: {
                        result = false;
                    }
                }
                return result;
            }
            if (this.comparable) {
                boolean result;
                Comparable value1 = (Comparable)this.getOperand(0).interpret(helper);
                Comparable value2 = (Comparable)this.getOperand(1).interpret(helper);
                int cmp = value1.compareTo(value2);
                switch (this.oper) {
                    case 8323: {
                        result = cmp < 0;
                        break;
                    }
                    case 8325: {
                        result = cmp <= 0;
                        break;
                    }
                    case 8322: {
                        result = cmp > 0;
                        break;
                    }
                    case 8324: {
                        result = cmp >= 0;
                        break;
                    }
                    case 8320: {
                        result = cmp == 0;
                        break;
                    }
                    case 8321: {
                        result = cmp != 0;
                        break;
                    }
                    default: {
                        result = false;
                    }
                }
                return result;
            }
            Object value1 = this.getOperand(0).interpret(helper);
            Object value2 = this.getOperand(1).interpret(helper);
            boolean result = this.oper == 8320 ? value1 == value2 : value1 != value2;
            return result;
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecuteException("ComparisonExpression.interpret : unexpected exception for operation " + this.token + this.getPos() + " in rule " + helper.getName(), e);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void compile(MethodVisitor mv, StackHeights currentStackHeights, StackHeights maxStackHeights) throws CompileException {
        block29: {
            block26: {
                block30: {
                    block28: {
                        block27: {
                            oper0 = this.getOperand(0);
                            oper1 = this.getOperand(1);
                            currentStack = currentStackHeights.stackCount;
                            max = 0;
                            oper0.compile(mv, currentStackHeights, maxStackHeights);
                            this.compileTypeConversion(oper0.getType(), this.comparisonType, mv, currentStackHeights, maxStackHeights);
                            oper1.compile(mv, currentStackHeights, maxStackHeights);
                            this.compileTypeConversion(oper1.getType(), this.comparisonType, mv, currentStackHeights, maxStackHeights);
                            if (!this.comparisonType.isNumeric()) break block26;
                            if (this.comparisonType == Type.B) break block27;
                            if (this.comparisonType == Type.S) break block27;
                            if (this.comparisonType == Type.S) break block27;
                            if (this.comparisonType != Type.I) break block28;
                        }
                        elsetarget = new Label();
                        endtarget = new Label();
                        max = 2;
                        switch (this.oper) {
                            case 8323: {
                                mv.visitJumpInsn(162, elsetarget);
                                mv.visitLdcInsn(true);
                                mv.visitJumpInsn(167, endtarget);
                                mv.visitLabel(elsetarget);
                                mv.visitLdcInsn(false);
                                mv.visitLabel(endtarget);
                                break;
                            }
                            case 8325: {
                                mv.visitJumpInsn(163, elsetarget);
                                mv.visitLdcInsn(true);
                                mv.visitJumpInsn(167, endtarget);
                                mv.visitLabel(elsetarget);
                                mv.visitLdcInsn(false);
                                mv.visitLabel(endtarget);
                                break;
                            }
                            case 8322: {
                                mv.visitJumpInsn(164, elsetarget);
                                mv.visitLdcInsn(true);
                                mv.visitJumpInsn(167, endtarget);
                                mv.visitLabel(elsetarget);
                                mv.visitLdcInsn(false);
                                mv.visitLabel(endtarget);
                                break;
                            }
                            case 8324: {
                                mv.visitJumpInsn(161, elsetarget);
                                mv.visitLdcInsn(true);
                                mv.visitJumpInsn(167, endtarget);
                                mv.visitLabel(elsetarget);
                                mv.visitLdcInsn(false);
                                mv.visitLabel(endtarget);
                                break;
                            }
                            case 8320: {
                                mv.visitJumpInsn(160, elsetarget);
                                mv.visitLdcInsn(true);
                                mv.visitJumpInsn(167, endtarget);
                                mv.visitLabel(elsetarget);
                                mv.visitLdcInsn(false);
                                mv.visitLabel(endtarget);
                                break;
                            }
                            case 8321: {
                                mv.visitJumpInsn(159, elsetarget);
                                mv.visitLdcInsn(true);
                                mv.visitJumpInsn(167, endtarget);
                                mv.visitLabel(elsetarget);
                                mv.visitLdcInsn(false);
                                mv.visitLabel(endtarget);
                            }
                        }
                        break block29;
                    }
                    if (this.comparisonType == Type.J) break block30;
                    if (this.comparisonType == Type.F) break block30;
                    if (this.comparisonType != Type.D && !this.comparable) break block29;
                }
                if (this.comparisonType == Type.J) {
                    mv.visitInsn(148);
                    max = 4;
                } else if (this.comparisonType == Type.F) {
                    max = 2;
                    mv.visitInsn(150);
                } else if (this.comparisonType == Type.D) {
                    max = 4;
                    mv.visitInsn(152);
                } else {
                    max = 2;
                    mv.visitMethodInsn(185, "java/lang/Comparable", "compareTo", "(Ljava/lang/Object;)I");
                }
                elsetarget = new Label();
                endtarget = new Label();
                switch (this.oper) {
                    case 8323: {
                        mv.visitJumpInsn(156, elsetarget);
                        mv.visitLdcInsn(true);
                        mv.visitJumpInsn(167, endtarget);
                        mv.visitLabel(elsetarget);
                        mv.visitLdcInsn(false);
                        mv.visitLabel(endtarget);
                        ** break;
                    }
                    case 8325: {
                        mv.visitJumpInsn(157, elsetarget);
                        mv.visitLdcInsn(true);
                        mv.visitJumpInsn(167, endtarget);
                        mv.visitLabel(elsetarget);
                        mv.visitLdcInsn(false);
                        mv.visitLabel(endtarget);
                        ** break;
                    }
                    case 8322: {
                        mv.visitJumpInsn(158, elsetarget);
                        mv.visitLdcInsn(true);
                        mv.visitJumpInsn(167, endtarget);
                        mv.visitLabel(elsetarget);
                        mv.visitLdcInsn(false);
                        mv.visitLabel(endtarget);
                        ** break;
                    }
                    case 8324: {
                        mv.visitJumpInsn(155, elsetarget);
                        mv.visitLdcInsn(true);
                        mv.visitJumpInsn(167, endtarget);
                        mv.visitLabel(elsetarget);
                        mv.visitLdcInsn(false);
                        mv.visitLabel(endtarget);
                        ** break;
                    }
                    case 8320: {
                        mv.visitJumpInsn(154, elsetarget);
                        mv.visitLdcInsn(true);
                        mv.visitJumpInsn(167, endtarget);
                        mv.visitLabel(elsetarget);
                        mv.visitLdcInsn(false);
                        mv.visitLabel(endtarget);
                        ** break;
                    }
                    case 8321: {
                        mv.visitJumpInsn(153, elsetarget);
                        mv.visitLdcInsn(true);
                        mv.visitJumpInsn(167, endtarget);
                        mv.visitLabel(elsetarget);
                        mv.visitLdcInsn(false);
                        mv.visitLabel(endtarget);
                    }
                }
lbl144:
                // 7 sources

                break block29;
            }
            max = 2;
            elsetarget = new Label();
            endtarget = new Label();
            if (this.oper == 8320) {
                mv.visitJumpInsn(166, elsetarget);
                mv.visitLdcInsn(true);
                mv.visitJumpInsn(167, endtarget);
                mv.visitLabel(elsetarget);
                mv.visitLdcInsn(false);
                mv.visitLabel(endtarget);
            } else {
                mv.visitJumpInsn(165, elsetarget);
                mv.visitLdcInsn(true);
                mv.visitJumpInsn(167, endtarget);
                mv.visitLabel(elsetarget);
                mv.visitLdcInsn(false);
                mv.visitLabel(endtarget);
            }
        }
        currentStackHeights.addStackCount(1 - max);
    }
}

