/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.helper;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jboss.byteman.agent.Transformer;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.synchronization.CountDown;
import org.jboss.byteman.synchronization.Counter;
import org.jboss.byteman.synchronization.Joiner;
import org.jboss.byteman.synchronization.Rendezvous;
import org.jboss.byteman.synchronization.Timer;
import org.jboss.byteman.synchronization.Waiter;

public class Helper {
    protected Rule rule;
    private static HashMap<Object, Joiner> joinerMap = new HashMap();
    private StackTraceElement[] stack = null;
    private static String RULE_CLASS_NAME = Rule.class.getCanonicalName();
    private static String RULE_EXECUTE_METHOD_NAME = "execute";
    private static int nextFileIndex = 0;
    private static HashMap<Object, PrintStream> traceMap = new HashMap();
    private static Set<Object> flagSet = new HashSet<Object>();
    private static HashMap<Object, CountDown> countDownMap = new HashMap();
    private static HashMap<Object, Counter> counterMap = new HashMap();
    private static HashMap<Object, Waiter> waitMap = new HashMap();
    private static HashMap<Object, Rendezvous> rendezvousMap = new HashMap();
    private static HashMap<Object, Timer> timerMap = new HashMap();

    protected Helper(Rule rule) {
        this.rule = rule;
    }

    public boolean debug(String text) {
        if (Transformer.isDebug()) {
            System.out.println("rule.debug{" + this.rule.getName() + "} : " + text);
        }
        return true;
    }

    public boolean openTrace(Object identifier) {
        return this.openTrace(identifier, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openTrace(Object identifier, String fileName) {
        if (identifier == null) {
            return false;
        }
        HashMap<Object, PrintStream> hashMap = traceMap;
        synchronized (hashMap) {
            FileOutputStream fos;
            File file;
            PrintStream stream = traceMap.get(identifier);
            String name = fileName;
            if (stream != null) {
                return false;
            }
            if (fileName == null) {
                name = this.nextFileName();
            }
            if ((file = new File(name)).exists() && !file.canWrite()) {
                if (fileName == null) {
                    while ((file = new File(name = this.nextFileName())).exists() && !file.canWrite()) {
                    }
                } else {
                    return false;
                }
            }
            try {
                fos = file.exists() ? new FileOutputStream(file, true) : new FileOutputStream(file, true);
            }
            catch (FileNotFoundException e) {
                return false;
            }
            PrintStream ps = new PrintStream(fos, true);
            traceMap.put(identifier, ps);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeTrace(Object identifier) {
        if (identifier == null || identifier.equals("out") || identifier.equals("err")) {
            return false;
        }
        HashMap<Object, PrintStream> hashMap = traceMap;
        synchronized (hashMap) {
            PrintStream ps = traceMap.get(identifier);
            if (ps != null) {
                ps.close();
                traceMap.remove(identifier);
                return true;
            }
        }
        return false;
    }

    public boolean trace(String message) {
        return this.trace("out", message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean trace(Object identifier, String message) {
        HashMap<Object, PrintStream> hashMap = traceMap;
        synchronized (hashMap) {
            PrintStream ps = traceMap.get(identifier);
            if (ps == null) {
                ps = this.openTrace(identifier) ? traceMap.get(identifier) : System.out;
            }
            ps.print(message);
            ps.flush();
        }
        return true;
    }

    public boolean traceln(String message) {
        return this.traceln("out", message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean traceln(Object identifier, String message) {
        HashMap<Object, PrintStream> hashMap = traceMap;
        synchronized (hashMap) {
            PrintStream ps = traceMap.get(identifier);
            if (ps == null) {
                ps = this.openTrace(identifier) ? traceMap.get(identifier) : System.out;
            }
            ps.println(message);
            ps.flush();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flag(Object identifier) {
        Set<Object> set = flagSet;
        synchronized (set) {
            return flagSet.add(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flagged(Object identifier) {
        Set<Object> set = flagSet;
        synchronized (set) {
            return flagSet.contains(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clear(Object identifier) {
        Set<Object> set = flagSet;
        synchronized (set) {
            return flagSet.remove(identifier);
        }
    }

    public boolean getCountDown(Object identifier) {
        return this.isCountDown(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCountDown(Object identifier) {
        HashMap<Object, CountDown> hashMap = countDownMap;
        synchronized (hashMap) {
            return countDownMap.get(identifier) != null;
        }
    }

    public boolean addCountDown(Object identifier, int count) {
        return this.createCountDown(identifier, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createCountDown(Object identifier, int count) {
        HashMap<Object, CountDown> hashMap = countDownMap;
        synchronized (hashMap) {
            if (countDownMap.get(identifier) == null) {
                countDownMap.put(identifier, new CountDown(count));
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean countDown(Object identifier) {
        HashMap<Object, CountDown> hashMap = countDownMap;
        synchronized (hashMap) {
            CountDown countDown = countDownMap.get(identifier);
            if (countDown != null) {
                boolean result = countDown.decrement();
                if (result) {
                    countDownMap.remove(identifier);
                }
                return result;
            }
        }
        return false;
    }

    public boolean waiting(Object identifier) {
        return this.getWaiter(identifier, false) != null;
    }

    public void waitFor(Object identifier) {
        this.waitFor(identifier, 0L);
    }

    public void waitFor(Object identifier, long millisecs) {
        Waiter waiter = this.getWaiter(identifier, true);
        waiter.waitFor(millisecs);
    }

    public boolean signalWake(Object identifier) {
        return this.signalWake(identifier, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean signalWake(Object identifier, boolean mustMeet) {
        Waiter waiter;
        if (!mustMeet) {
            Waiter waiter2 = this.removeWaiter(identifier);
            if (waiter2 != null) {
                return waiter2.signalWake();
            }
            return false;
        }
        HashMap<Object, Waiter> hashMap = waitMap;
        synchronized (hashMap) {
            waiter = this.removeWaiter(identifier);
            if (waiter != null) {
                return waiter.signalWake();
            }
            waiter = new Waiter(identifier, true, false);
            waitMap.put(identifier, waiter);
        }
        hashMap = waiter;
        synchronized (hashMap) {
            while (!waiter.waiting()) {
                try {
                    waiter.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        hashMap = waitMap;
        synchronized (hashMap) {
            this.removeWaiter(identifier);
        }
        return true;
    }

    public boolean signalKill(Object identifier) {
        return this.signalThrow(identifier);
    }

    public boolean signalKill(Object identifier, boolean mustMeet) {
        return this.signalThrow(identifier, mustMeet);
    }

    public boolean signalThrow(Object identifier) {
        return this.signalThrow(identifier, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean signalThrow(Object identifier, boolean mustMeet) {
        Waiter waiter;
        if (!mustMeet) {
            Waiter waiter2 = this.removeWaiter(identifier);
            if (waiter2 != null) {
                return waiter2.signalThrow();
            }
            return false;
        }
        HashMap<Object, Waiter> hashMap = waitMap;
        synchronized (hashMap) {
            waiter = this.removeWaiter(identifier);
            if (waiter != null) {
                return waiter.signalThrow();
            }
            waiter = new Waiter(identifier, true, false);
            waitMap.put(identifier, waiter);
        }
        hashMap = waiter;
        synchronized (hashMap) {
            while (!waiter.waiting()) {
                try {
                    waiter.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        hashMap = waitMap;
        synchronized (hashMap) {
            this.removeWaiter(identifier);
        }
        return true;
    }

    public void delay(long millisecs) {
        try {
            Thread.sleep(millisecs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean createRendezvous(Object identifier, int expected) {
        return this.createRendezvous(identifier, expected, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createRendezvous(Object identifier, int expected, boolean restartable) {
        HashMap<Object, Rendezvous> hashMap = rendezvousMap;
        synchronized (hashMap) {
            Rendezvous rendezvous = rendezvousMap.get(identifier);
            if (rendezvous != null) {
                return false;
            }
            rendezvous = new Rendezvous(expected, restartable);
            rendezvousMap.put(identifier, rendezvous);
        }
        return true;
    }

    public boolean isRendezvous(Object identifier, int expected) {
        int arrived = this.getRendezvous(identifier, expected);
        return arrived >= 0 && arrived < expected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRendezvous(Object identifier, int expected) {
        Rendezvous rendezvous = rendezvousMap.get(identifier);
        if (rendezvous == null || rendezvous.getExpected() != expected) {
            return -1;
        }
        Rendezvous rendezvous2 = rendezvous;
        synchronized (rendezvous2) {
            return rendezvous.getArrived();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rendezvous(Object identifier) {
        Rendezvous rendezvous = rendezvousMap.get(identifier);
        if (rendezvous != null) {
            Rendezvous rendezvous2 = rendezvous;
            synchronized (rendezvous2) {
                int result = rendezvous.rendezvous();
                if (rendezvous.needsRemove()) {
                    rendezvousMap.remove(identifier);
                    rendezvous.setRemoved();
                }
                return result;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteRendezvous(Object identifier, int expected) {
        Rendezvous rendezvous = rendezvousMap.get(identifier);
        if (rendezvous == null || rendezvous.getExpected() != expected) {
            return false;
        }
        Rendezvous rendezvous2 = rendezvous;
        synchronized (rendezvous2) {
            if (rendezvous.delete()) {
                if (rendezvous.needsRemove()) {
                    rendezvousMap.remove(identifier);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createJoin(Object key, int max) {
        if (max <= 0) {
            return false;
        }
        HashMap<Object, Joiner> hashMap = joinerMap;
        synchronized (hashMap) {
            if (joinerMap.get(key) != null) {
                return false;
            }
            joinerMap.put(key, new Joiner(max));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJoin(Object key, int max) {
        HashMap<Object, Joiner> hashMap = joinerMap;
        synchronized (hashMap) {
            Joiner joiner = joinerMap.get(key);
            if (joiner == null || joiner.getMax() != max) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean joinEnlist(Object key) {
        Joiner joiner;
        HashMap<Object, Joiner> hashMap = joinerMap;
        synchronized (hashMap) {
            joiner = joinerMap.get(key);
        }
        if (joiner == null) {
            return false;
        }
        Thread current = Thread.currentThread();
        switch (joiner.addChild(current)) {
            case DUPLICATE: 
            case EXCESS: {
                return false;
            }
            case ADDED: 
            case FILLED: {
                return true;
            }
        }
        HashMap<Object, Joiner> hashMap2 = joinerMap;
        synchronized (hashMap2) {
            joinerMap.remove(joiner);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean joinWait(Object key, int count) {
        Joiner joiner;
        HashMap<Object, Joiner> hashMap = joinerMap;
        synchronized (hashMap) {
            joiner = joinerMap.get(key);
        }
        if (joiner == null || joiner.getMax() != count) {
            return false;
        }
        Thread current = Thread.currentThread();
        if (joiner.joinChildren(current)) {
            HashMap<Object, Joiner> hashMap2 = joinerMap;
            synchronized (hashMap2) {
                joinerMap.remove(joiner);
            }
            return true;
        }
        return true;
    }

    public boolean createCounter(Object o) {
        return this.createCounter(o, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createCounter(Object o, int value) {
        HashMap<Object, Counter> hashMap = counterMap;
        synchronized (hashMap) {
            Counter counter = counterMap.get(o);
            if (counter != null) {
                return false;
            }
            counterMap.put(o, new Counter(value));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteCounter(Object o) {
        HashMap<Object, Counter> hashMap = counterMap;
        synchronized (hashMap) {
            Counter counter = counterMap.get(o);
            if (counter != null) {
                counterMap.remove(o);
                return true;
            }
            return false;
        }
    }

    public int readCounter(Object o) {
        return this.readCounter(o, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readCounter(Object o, boolean zero) {
        HashMap<Object, Counter> hashMap = counterMap;
        synchronized (hashMap) {
            Counter counter = counterMap.get(o);
            if (counter == null) {
                counter = new Counter();
                counterMap.put(o, counter);
            }
            return counter.count(zero);
        }
    }

    public int incrementCounter(Object o) {
        return this.incrementCounter(o, 1);
    }

    public int decrementCounter(Object o) {
        return this.incrementCounter(o, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int incrementCounter(Object o, int amount) {
        HashMap<Object, Counter> hashMap = counterMap;
        synchronized (hashMap) {
            Counter counter = counterMap.get(o);
            if (counter == null) {
                counter = new Counter();
                counterMap.put(o, counter);
            }
            return counter.increment(amount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createTimer(Object o) {
        HashMap<Object, Timer> hashMap = timerMap;
        synchronized (hashMap) {
            Timer timer = timerMap.get(o);
            if (timer != null) {
                return false;
            }
            timerMap.put(o, new Timer());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteTimer(Object o) {
        HashMap<Object, Timer> hashMap = timerMap;
        synchronized (hashMap) {
            Timer timer = timerMap.get(o);
            if (timer != null) {
                timerMap.remove(o);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getElapsedTimeFromTimer(Object o) {
        HashMap<Object, Timer> hashMap = timerMap;
        synchronized (hashMap) {
            Timer timer = timerMap.get(o);
            if (timer == null) {
                timer = new Timer();
                timerMap.put(o, timer);
            }
            return timer.getElapsedTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long resetTimer(Object o) {
        HashMap<Object, Timer> hashMap = timerMap;
        synchronized (hashMap) {
            Timer timer = timerMap.get(o);
            if (timer == null) {
                timer = new Timer();
                timerMap.put(o, timer);
            }
            return timer.reset();
        }
    }

    public void killThread() {
        throw new ExecuteException("rule " + this.rule.getName() + " : killing thread " + Thread.currentThread().getName());
    }

    public void killJVM() {
        this.killJVM(-1);
    }

    public void killJVM(int exitCode) {
        Runtime.getRuntime().halt(-1);
    }

    public boolean callerEquals(String name) {
        return this.callerEquals(name, false);
    }

    public boolean callerEquals(String name, int frameCount) {
        return this.callerEquals(name, 1, frameCount);
    }

    public boolean callerEquals(String name, int startFrame, int frameCount) {
        return this.callerEquals(name, false, startFrame, frameCount);
    }

    public boolean callerEquals(String name, boolean includeClass) {
        return this.callerEquals(name, includeClass, false);
    }

    public boolean callerEquals(String name, boolean includeClass, int frameCount) {
        return this.callerEquals(name, includeClass, false, frameCount);
    }

    public boolean callerEquals(String name, boolean includeClass, int startFrame, int frameCount) {
        return this.callerEquals(name, includeClass, false, startFrame, frameCount);
    }

    public boolean callerEquals(String name, boolean includeClass, boolean includePackage) {
        return this.callerEquals(name, includeClass, includePackage, 1);
    }

    public boolean callerEquals(String name, boolean includeClass, boolean includePackage, int frameCount) {
        return this.callerCheck(name, false, includeClass, includePackage, 1, frameCount);
    }

    public boolean callerEquals(String name, boolean includeClass, boolean includePackage, int startFrame, int frameCount) {
        return this.callerCheck(name, false, includeClass, includePackage, startFrame, frameCount);
    }

    public boolean callerMatches(String regExp) {
        return this.callerMatches(regExp, false);
    }

    public boolean callerMatches(String regExp, int frameCount) {
        return this.callerMatches(regExp, 1, frameCount);
    }

    public boolean callerMatches(String regExp, int startFrame, int frameCount) {
        return this.callerMatches(regExp, false, startFrame, frameCount);
    }

    public boolean callerMatches(String regExp, boolean includeClass) {
        return this.callerMatches(regExp, includeClass, false);
    }

    public boolean callerMatches(String regExp, boolean includeClass, int frameCount) {
        return this.callerMatches(regExp, includeClass, false, frameCount);
    }

    public boolean callerMatches(String regExp, boolean includeClass, int startFrame, int frameCount) {
        return this.callerMatches(regExp, includeClass, false, startFrame, frameCount);
    }

    public boolean callerMatches(String regExp, boolean includeClass, boolean includePackage) {
        return this.callerMatches(regExp, includeClass, includePackage, 1);
    }

    public boolean callerMatches(String regExp, boolean includeClass, boolean includePackage, int frameCount) {
        return this.callerMatches(regExp, includeClass, includePackage, 1, frameCount);
    }

    public boolean callerMatches(String regExp, boolean includeClass, boolean includePackage, int startFrame, int frameCount) {
        return this.callerCheck(regExp, true, includeClass, includePackage, startFrame, frameCount);
    }

    public boolean callerCheck(String match, boolean isRegExp, boolean includeClass, boolean includePackage, int startFrame, int frameCount) {
        StackTraceElement[] stack = this.getStack();
        int triggerIndex = this.triggerIndex(stack);
        if (startFrame < 0) {
            return false;
        }
        int lastIndex = frameCount <= 0 ? Integer.MAX_VALUE : startFrame + frameCount;
        int matched = this.matchIndex(stack, match, isRegExp, includeClass, includePackage, triggerIndex + startFrame, triggerIndex + lastIndex);
        return matched >= 0;
    }

    public void traceStack() {
        this.traceStack(null);
    }

    public void traceStack(String prefix) {
        this.traceStack(prefix, "out");
    }

    public void traceStack(String prefix, Object key) {
        this.traceStack(prefix, key, 0);
    }

    public void traceStack(int maxFrames) {
        this.traceStack((String)null, maxFrames);
    }

    public void traceStack(String prefix, int maxFrames) {
        this.traceStack(prefix, "out", maxFrames);
    }

    public void traceStack(String prefix, Object key, int maxFrames) {
        String stackTrace = this.formatStack(prefix, maxFrames);
        this.trace(key, stackTrace);
    }

    public void traceStackMatching(String regExp) {
        this.traceStackMatching(regExp, null);
    }

    public void traceStackMatching(String regExp, String prefix) {
        this.traceStackMatching(regExp, prefix, (Object)"out");
    }

    public void traceStackMatching(String regExp, String prefix, Object key) {
        this.traceStackMatching(regExp, false, prefix, key);
    }

    public void traceStackMatching(String regExp, boolean includeClass) {
        this.traceStackMatching(regExp, includeClass, false);
    }

    public void traceStackMatching(String regExp, boolean includeClass, String prefix) {
        this.traceStackMatching(regExp, includeClass, false, prefix);
    }

    public void traceStackMatching(String regExp, boolean includeClass, String prefix, Object key) {
        this.traceStackMatching(regExp, includeClass, false, prefix, key);
    }

    public void traceStackMatching(String regExp, boolean includeClass, boolean includePackage) {
        this.traceStackMatching(regExp, includeClass, includePackage, null);
    }

    public void traceStackMatching(String regExp, boolean includeClass, boolean includePackage, String prefix) {
        this.traceStackMatching(regExp, includeClass, includePackage, prefix, "out");
    }

    public void traceStackMatching(String regExp, boolean includeClass, boolean includePackage, String prefix, Object key) {
        String stackTrace = this.formatStackMatching(regExp, includeClass, includePackage, prefix);
        this.trace(key, stackTrace);
    }

    public void traceStackBetween(String from, String to) {
        this.traceStackBetween(from, to, null);
    }

    public void traceStackBetween(String from, String to, String prefix) {
        this.traceStackBetween(from, to, prefix, (Object)"out");
    }

    public void traceStackBetween(String from, String to, String prefix, Object key) {
        this.traceStackBetween(from, to, false, prefix, key);
    }

    public void traceStackBetween(String from, String to, boolean includeClass) {
        this.traceStackBetween(from, to, includeClass, false);
    }

    public void traceStackBetween(String from, String to, boolean includeClass, String prefix) {
        this.traceStackBetween(from, to, includeClass, false, prefix);
    }

    public void traceStackBetween(String from, String to, boolean includeClass, String prefix, Object key) {
        this.traceStackBetween(from, to, includeClass, false, prefix, key);
    }

    public void traceStackBetween(String from, String to, boolean includeClass, boolean includePackage) {
        this.traceStackBetween(from, to, includeClass, includePackage, null);
    }

    public void traceStackBetween(String from, String to, boolean includeClass, boolean includePackage, String prefix) {
        this.traceStackBetween(from, to, includeClass, includePackage, prefix, "out");
    }

    public void traceStackBetween(String from, String to, boolean includeClass, boolean includePackage, String prefix, Object key) {
        this.traceStackRange(from, to, false, includeClass, includePackage, prefix, key);
    }

    public void traceStackBetweenMatches(String from, String to) {
        this.traceStackBetweenMatches(from, to, null);
    }

    public void traceStackBetweenMatches(String from, String to, String prefix) {
        this.traceStackBetweenMatches(from, to, prefix, (Object)"out");
    }

    public void traceStackBetweenMatches(String from, String to, String prefix, Object key) {
        this.traceStackBetweenMatches(from, to, false, prefix, key);
    }

    public void traceStackBetweenMatches(String from, String to, boolean includeClass) {
        this.traceStackBetweenMatches(from, to, includeClass, false);
    }

    public void traceStackBetweenMatches(String from, String to, boolean includeClass, String prefix) {
        this.traceStackBetweenMatches(from, to, includeClass, false, prefix);
    }

    public void traceStackBetweenMatches(String from, String to, boolean includeClass, String prefix, Object key) {
        this.traceStackBetweenMatches(from, to, includeClass, false, prefix, key);
    }

    public void traceStackBetweenMatches(String from, String to, boolean includeClass, boolean includePackage) {
        this.traceStackBetweenMatches(from, to, includeClass, includePackage, null);
    }

    public void traceStackBetweenMatches(String from, String to, boolean includeClass, boolean includePackage, String prefix) {
        this.traceStackBetweenMatches(from, to, includeClass, includePackage, prefix, "out");
    }

    public void traceStackBetweenMatches(String from, String to, boolean includeClass, boolean includePackage, String prefix, Object key) {
        this.traceStackRange(from, to, true, includeClass, includePackage, prefix, key);
    }

    public void traceStackRange(String from, String to, boolean isRegExp, boolean includeClass, boolean includePackage, String prefix, Object key) {
        String stackTrace = this.formatStackRange(from, to, isRegExp, includeClass, includePackage, prefix);
        this.trace(key, stackTrace);
    }

    public String formatStack() {
        return this.formatStack(null);
    }

    public String formatStack(String prefix) {
        return this.formatStack(prefix, 0);
    }

    public String formatStack(int maxFrames) {
        return this.formatStack(null, maxFrames);
    }

    public String formatStack(String prefix, int maxFrames) {
        StringBuffer buffer = new StringBuffer();
        StackTraceElement[] stack = this.getStack();
        int l = stack.length;
        int i = this.triggerIndex(stack);
        if (i < 0) {
            return "";
        }
        if (prefix != null) {
            buffer.append(prefix);
        } else {
            buffer.append("Stack trace for thread ");
            buffer.append(Thread.currentThread().getName());
            buffer.append('\n');
        }
        boolean dotdotdot = false;
        if (maxFrames > 0 && i + maxFrames < l) {
            l = i + maxFrames;
            dotdotdot = true;
        }
        while (i < l) {
            this.printlnFrame(buffer, stack[i]);
            ++i;
        }
        if (dotdotdot) {
            buffer.append("  . . .\n");
        }
        return buffer.toString();
    }

    public String formatStackMatching(String regExp) {
        return this.formatStackMatching(regExp, null);
    }

    public String formatStackMatching(String regExp, String prefix) {
        return this.formatStackMatching(regExp, false, prefix);
    }

    public String formatStackMatching(String regExp, boolean includeClass) {
        return this.formatStackMatching(regExp, includeClass, false);
    }

    public String formatStackMatching(String regExp, boolean includeClass, String prefix) {
        return this.formatStackMatching(regExp, includeClass, false, prefix);
    }

    public String formatStackMatching(String regExp, boolean includeClass, boolean includePackage) {
        return this.formatStackMatching(regExp, includeClass, includePackage, null);
    }

    public String formatStackMatching(String regExp, boolean includeClass, boolean includePackage, String prefix) {
        StringBuffer buffer = new StringBuffer();
        StackTraceElement[] stack = this.getStack();
        int l = stack.length;
        int i = this.triggerIndex(stack);
        if (i < 0) {
            return "";
        }
        if (prefix != null) {
            buffer.append(prefix);
        } else {
            buffer.append("Stack trace for thread ");
            buffer.append(Thread.currentThread().getName());
            buffer.append(" matching ");
            buffer.append(regExp);
            buffer.append('\n');
        }
        while (i < l) {
            String fullName;
            if (includeClass) {
                int dotIdx;
                String className = stack[i].getClassName();
                if (!includePackage && (dotIdx = className.lastIndexOf(46)) >= 0) {
                    className = className.substring(dotIdx + 1);
                }
                fullName = className + "." + stack[i].getMethodName();
            } else {
                fullName = stack[i].getMethodName();
            }
            if (fullName.matches(regExp)) {
                this.printlnFrame(buffer, stack[i]);
            }
            ++i;
        }
        return buffer.toString();
    }

    public String formatStackBetween(String from, String to) {
        return this.formatStackBetween(from, to, null);
    }

    public String formatStackBetween(String from, String to, String prefix) {
        return this.formatStackBetween(from, to, false, false, prefix);
    }

    public String formatStackBetween(String from, String to, boolean includeClass) {
        return this.formatStackBetween(from, to, includeClass, false);
    }

    public String formatStackBetween(String from, String to, boolean includeClass, String prefix) {
        return this.formatStackBetween(from, to, includeClass, false, prefix);
    }

    public String formatStackBetween(String from, String to, boolean includeClass, boolean includePackage) {
        return this.formatStackBetween(from, to, includeClass, includePackage, null);
    }

    public String formatStackBetween(String from, String to, boolean includeClass, boolean includePackage, String prefix) {
        return this.formatStackRange(from, to, false, includeClass, includePackage, prefix);
    }

    public String formatStackBetweenMatches(String from, String to) {
        return this.formatStackBetweenMatches(from, to, null);
    }

    public String formatStackBetweenMatches(String from, String to, String prefix) {
        return this.formatStackBetweenMatches(from, to, false, false, prefix);
    }

    public String formatStackBetweenMatches(String from, String to, boolean includeClass) {
        return this.formatStackBetweenMatches(from, to, includeClass, false);
    }

    public String formatStackBetweenMatches(String from, String to, boolean includeClass, String prefix) {
        return this.formatStackBetweenMatches(from, to, includeClass, false, prefix);
    }

    public String formatStackBetweenMatches(String from, String to, boolean includeClass, boolean includePackage) {
        return this.formatStackBetweenMatches(from, to, includeClass, includePackage, null);
    }

    public String formatStackBetweenMatches(String from, String to, boolean includeClass, boolean includePackage, String prefix) {
        return this.formatStackRange(from, to, true, includeClass, includePackage, prefix);
    }

    public String formatStackRange(String from, String to, boolean isRegExp, boolean includeClass, boolean includePackage, String prefix) {
        int last;
        int first;
        StringBuffer buffer = new StringBuffer();
        StackTraceElement[] stack = this.getStack();
        int l = stack.length;
        int i = this.triggerIndex(stack);
        if (i < 0) {
            return "";
        }
        if (from != null) {
            first = this.matchIndex(stack, from, isRegExp, includeClass, includePackage, i, l);
            if (first < 0) {
                return "";
            }
        } else {
            first = i;
        }
        if (to != null) {
            last = this.matchIndex(stack, to, isRegExp, includeClass, includePackage, first + 1, l);
            if (last < 0) {
                last = l - 1;
            }
        } else {
            last = l - 1;
        }
        if (prefix != null) {
            buffer.append(prefix);
        } else {
            buffer.append("Stack trace (restricted) for ");
            buffer.append(Thread.currentThread().getName());
            buffer.append('\n');
        }
        for (i = first; i <= last; ++i) {
            this.printlnFrame(buffer, stack[i]);
        }
        return buffer.toString();
    }

    public void setTriggering(boolean enabled) {
        if (enabled) {
            Rule.enableTriggers();
        } else {
            Rule.disableTriggers();
        }
    }

    public String toString() {
        return this.rule.getName();
    }

    public static void activated() {
        if (Transformer.isDebug()) {
            System.out.println("Default helper activated");
        }
    }

    public static void deactivated() {
        if (Transformer.isDebug()) {
            System.out.println("Default helper deactivated");
        }
    }

    public static void installed(Rule rule) {
        if (Transformer.isDebug()) {
            System.out.println("Installed rule using default helper : " + rule.getName());
        }
    }

    public static void uninstalled(Rule rule) {
        if (Transformer.isDebug()) {
            System.out.println("Uninstalled rule using default helper : " + rule.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StackTraceElement[] getStack() {
        if (this.stack == null) {
            Helper helper = this;
            synchronized (helper) {
                this.stack = Thread.currentThread().getStackTrace();
            }
        }
        return this.stack;
    }

    protected int triggerIndex(StackTraceElement[] stack) {
        int i;
        int l = stack.length;
        for (i = 0; !(i >= l || RULE_CLASS_NAME.equals(stack[i].getClassName()) && RULE_EXECUTE_METHOD_NAME.equals(stack[i].getMethodName())); ++i) {
        }
        if (i >= l - 1 || !RULE_CLASS_NAME.equals(stack[i].getClassName()) || !RULE_EXECUTE_METHOD_NAME.equals(stack[i].getMethodName())) {
            new ExecuteException("Helper.formatStack : can only be called below Rule.execute()").printStackTrace();
            return -1;
        }
        return i + 2;
    }

    protected int matchIndex(StackTraceElement[] stack, String pattern, boolean isRegExp, boolean includeClass, boolean includePackage, int start, int limit) {
        int l = stack.length;
        int i = start;
        if (limit > l) {
            limit = l;
        }
        while (i < limit) {
            String fullName;
            if (includeClass) {
                int dotIdx;
                String className = stack[i].getClassName();
                if (!includePackage && (dotIdx = className.lastIndexOf(46)) >= 0) {
                    className = className.substring(dotIdx + 1);
                }
                fullName = className + "." + stack[i].getMethodName();
            } else {
                fullName = stack[i].getMethodName();
            }
            if (isRegExp ? fullName.matches(pattern) : fullName.equals(pattern)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void printlnFrame(StringBuffer buffer, StackTraceElement frame) {
        this.printFrame(buffer, frame);
        buffer.append('\n');
    }

    protected void printFrame(StringBuffer buffer, StackTraceElement frame) {
        buffer.append(frame.getClassName());
        buffer.append(".");
        buffer.append(frame.getMethodName());
        String fileName = frame.getFileName();
        if (fileName != null) {
            buffer.append("(");
            buffer.append(fileName);
            buffer.append(":");
            buffer.append(frame.getLineNumber());
            buffer.append(")");
        } else {
            buffer.append(" (Unknown Source)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Waiter getWaiter(Object object, boolean createIfAbsent) {
        Waiter waiter;
        HashMap<Object, Waiter> hashMap = waitMap;
        synchronized (hashMap) {
            waiter = waitMap.get(object);
            if (waiter == null && createIfAbsent) {
                waiter = new Waiter(object);
                waitMap.put(object, waiter);
            }
        }
        return waiter;
    }

    private Waiter removeWaiter(Object object) {
        return waitMap.remove(object);
    }

    private static synchronized int nextFileIndex() {
        return nextFileIndex++;
    }

    private String nextFileName() {
        StringWriter writer = new StringWriter();
        String digits = Integer.toString(Helper.nextFileIndex());
        int numDigits = digits.length();
        writer.write("trace");
        for (int idx = 9; idx > numDigits; --idx) {
            writer.write(48);
        }
        writer.write(digits);
        return writer.toString();
    }

    static {
        traceMap.put("out", System.out);
        traceMap.put("err", System.err);
    }
}

