/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jboss.byteman.agent.RuleScript;
import org.jboss.byteman.agent.ScriptRepository;
import org.jboss.byteman.agent.Transform;
import org.jboss.byteman.agent.Transformer;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.binding.Binding;
import org.jboss.byteman.rule.binding.Bindings;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ParseException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.type.Type;
import org.jboss.byteman.rule.type.TypeGroup;
import org.jboss.byteman.rule.type.TypeHelper;

public class TestScript {
    private int errorCount = 0;
    private int parseErrorCount = 0;
    private int typeErrorCount = 0;
    boolean verbose;

    public static void main(String[] args) {
        int length = args.length;
        LinkedList<String> packages = new LinkedList<String>();
        int start = 0;
        boolean verbose = false;
        while (start < length) {
            if (args[start].equals("-p")) {
                if (++start == length) {
                    TestScript.usage();
                    return;
                }
                String packageName = args[start++];
                packages.add(packageName);
                continue;
            }
            if (args[start].equals("-v")) {
                ++start;
                verbose = true;
                continue;
            }
            if (!args[start].equals("-h")) break;
            TestScript.usage();
            return;
        }
        if (start == length) {
            TestScript.usage();
            return;
        }
        TestScript testScript = new TestScript(verbose);
        String[] packagesArray = new String[packages.size()];
        testScript.testScript(packages.toArray(packagesArray), args, start);
    }

    public static void usage() {
        System.out.println("usage : java org.jboss.byteman.TestScript [-p <package>]* [-v] scriptfile1 ...");
        System.out.println("        -p specify package to lookup non-package qualified classnames");
        System.out.println("        -v display parsed rules");
        System.out.println("        n.b. place the byteman jar and classes mentioned in the ");
        System.out.println("        scripts in the classpath");
    }

    public void testScript(String[] packages, String[] files, int firstFile) {
        ArrayList<String> ruleTexts = new ArrayList<String>();
        ArrayList<String> ruleFiles = new ArrayList<String>();
        for (int i = firstFile; i < files.length; ++i) {
            String file = files[i];
            try {
                int count;
                FileInputStream fis = new FileInputStream(new File(file));
                int max = fis.available();
                byte[] bytes = new byte[max];
                int read = count = fis.read(bytes);
                while (count > 0 && read < max) {
                    count = fis.read(bytes, read, max - read);
                }
                if (read < max) {
                    System.err.println("TestScript: unable to read full contents of file : " + file);
                }
                String ruleText = new String(bytes);
                ruleTexts.add(ruleText);
                ruleFiles.add(file);
                continue;
            }
            catch (IOException ioe) {
                System.err.println("TestScript: unable to open file : " + file);
            }
        }
        this.checkRules(packages, ruleTexts, ruleFiles);
    }

    private void checkRules(String[] packages, List<String> ruleTexts, List<String> ruleFiles) {
        ClassLoader loader = this.getClass().getClassLoader();
        ScriptRepository repository = new ScriptRepository(false);
        ArrayList<RuleScript> allScripts = new ArrayList<RuleScript>();
        Iterator<String> textsIter = ruleTexts.iterator();
        Iterator<String> filesIter = ruleFiles.iterator();
        while (textsIter.hasNext()) {
            String ruleText = textsIter.next();
            String ruleFile = filesIter.next();
            List<RuleScript> ruleScripts = null;
            try {
                ruleScripts = repository.processScripts(ruleText, ruleFile);
                allScripts.addAll(ruleScripts);
            }
            catch (Exception e) {
                System.out.println("TestScript : Error processing rule file " + ruleFile + " : " + e);
                ++this.errorCount;
            }
        }
        ArrayList<String> emptyInitialTexts = new ArrayList<String>();
        ArrayList<String> emptyInitialFiles = new ArrayList<String>();
        for (RuleScript script : allScripts) {
            String targetClassName = script.getTargetClass();
            Class<?> targetClass = null;
            try {
                targetClass = loader.loadClass(targetClassName);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (targetClass == null && targetClassName.indexOf(46) < 0) {
                for (int i = 0; i < packages.length; ++i) {
                    String qualifiedName = packages[i] + "." + targetClassName;
                    try {
                        targetClass = loader.loadClass(qualifiedName);
                    }
                    catch (ClassNotFoundException e) {
                    }
                    catch (Exception e) {
                        System.out.println("TestScript: unexpected error looking up " + targetClassName + " in package " + packages[i]);
                        return;
                    }
                    if (targetClass != null) break;
                }
            }
            if (targetClass == null) {
                System.out.println("TestScript : Could not load class " + targetClassName + " declared in rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
                ++this.errorCount;
                continue;
            }
            if (script.isInterface() && !targetClass.isInterface()) {
                System.out.println("TestScript : found class instead of interface for rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
                ++this.errorCount;
                continue;
            }
            if (!script.isInterface() && targetClass.isInterface()) {
                System.out.println("TestScript : found interface instead of class for rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
                ++this.errorCount;
                continue;
            }
            if (!script.isInterface()) {
                byte[] bytes;
                block41: {
                    String resourceName = targetClass.getName().replace(".", "/") + ".class";
                    bytes = null;
                    try {
                        int read;
                        int count;
                        InputStream stream = loader.getResourceAsStream(resourceName);
                        int max = stream.available();
                        bytes = new byte[max];
                        for (read = count = stream.read(bytes); count > 0 && read < max; read += count) {
                            count = stream.read(bytes, read, max - read);
                        }
                        if (read < max) {
                            System.out.println("TestScript : Could not load bytecode for class " + targetClassName + " declared in rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
                            System.out.println();
                            ++this.errorCount;
                        }
                        break block41;
                    }
                    catch (Exception e) {
                        System.out.println("TestScript : Could not load bytecode for class " + targetClassName + " declared in rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
                        System.out.println();
                        ++this.errorCount;
                    }
                    continue;
                }
                Transformer transformer = null;
                try {
                    transformer = new Transformer(null, emptyInitialTexts, emptyInitialFiles, false);
                }
                catch (Exception e) {
                    // empty catch block
                }
                System.out.println("checking rule " + script.getName());
                bytes = transformer.transform(script, loader, targetClass.getName(), bytes);
            }
            if (script.hasTransform(targetClass)) {
                List<Transform> transforms = script.getTransformed();
                int numTransforms = transforms.size();
                for (Transform transform : transforms) {
                    Throwable throwable = transform.getThrowable();
                    Rule rule = transform.getRule();
                    if (throwable != null) {
                        ++this.errorCount;
                        if (throwable instanceof ParseException) {
                            System.out.println("TestScript : Failed to parse rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
                            System.out.println();
                            ++this.parseErrorCount;
                        } else if (throwable instanceof TypeException) {
                            System.out.println("TestScript : Failed to type check rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
                            System.out.println();
                            ++this.typeErrorCount;
                        } else {
                            System.out.println("TestScript : Error transforming class " + targetClassName + " using  rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
                            System.out.println();
                        }
                        throwable.printStackTrace(System.out);
                        System.out.println();
                        continue;
                    }
                    System.out.println("parsed rule \"" + script.getName() + "\" for class " + transform.getInternalClassName());
                    if (this.verbose) {
                        System.out.println("# File " + script.getFile() + " line " + script.getLine());
                        System.out.println(rule);
                    }
                    try {
                        rule.typeCheck();
                    }
                    catch (TypeException te) {
                        System.out.println("TestScript : Failed to type check rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
                        ++this.typeErrorCount;
                        te.printStackTrace(System.out);
                        System.out.println();
                        continue;
                    }
                    if (script.isOverride()) {
                        System.out.println("type checked overriding rule \"" + script.getName() + "\" against method in declared class");
                    } else {
                        System.out.println("type checked rule \"" + script.getName() + "\"");
                    }
                    System.out.println();
                }
                continue;
            }
            if (targetClass.isInterface() || script.isOverride()) {
                Rule rule;
                try {
                    rule = Rule.create(script, loader, null);
                }
                catch (ParseException pe) {
                    System.out.println("TestScript : Failed to type check rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
                    ++this.parseErrorCount;
                    ++this.errorCount;
                    pe.printStackTrace(System.out);
                    System.out.println();
                    continue;
                }
                catch (TypeException te) {
                    System.out.println("TestScript : Failed to type check rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
                    ++this.typeErrorCount;
                    ++this.errorCount;
                    te.printStackTrace(System.out);
                    System.out.println();
                    continue;
                }
                catch (Throwable th) {
                    System.out.println("TestScript : Failed to process rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
                    ++this.errorCount;
                    th.printStackTrace(System.out);
                    System.out.println();
                    continue;
                }
                System.out.println("parsed rule \"" + script.getName() + "\"");
                if (this.verbose) {
                    System.out.println("# File " + script.getFile() + " line " + script.getLine());
                    System.out.println(rule);
                }
                this.typeCheckAgainstMethodDeclaration(rule, script, targetClass, loader);
                continue;
            }
            System.out.println("TestScript : Failed to transform class " + targetClassName + " using rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
            System.out.println();
            ++this.errorCount;
        }
        if (this.errorCount != 0) {
            System.err.println("TestScript: " + this.errorCount + " total errors");
            System.err.println("            " + this.parseErrorCount + " parse errors");
            System.err.println("            " + this.typeErrorCount + " type errors");
        } else {
            System.err.println("TestScript: no errors");
        }
    }

    private void typeCheckAgainstMethodDeclaration(Rule rule, RuleScript script, Class targetClass, ClassLoader loader) {
        String targetMethodName = script.getTargetMethod();
        String targetName = TypeHelper.parseMethodName(targetMethodName);
        String targetDesc = TypeHelper.parseMethodDescriptor(targetMethodName);
        if (targetName == "<clinit>") {
            System.err.println("TestScript: cannot type check <clinit> rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
            System.err.println();
            return;
        }
        if (targetMethodName == "<init>") {
            if (script.isInterface()) {
                System.err.println("TestScript: invalid target method <init> for interface rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
                System.err.println();
                return;
            }
            System.err.println("TestScript: invalid target method <init> for overriding rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
            System.err.println();
            return;
        }
        Method[] candidates = targetClass.getDeclaredMethods();
        int matchCount = 0;
        for (Method candidate : candidates) {
            String candidateName = candidate.getName();
            String candidateDesc = TestScript.makeDescriptor(candidate);
            if (!targetName.equals(candidateName) || !targetDesc.equals("") && !TypeHelper.equalDescriptors(targetDesc, candidateDesc)) continue;
            if (++matchCount > 1) {
                try {
                    rule = Rule.create(script, loader, null);
                }
                catch (ParseException e) {
                }
                catch (TypeException e) {
                }
                catch (CompileException e) {
                    // empty catch block
                }
            }
            int access = 0;
            Class<?>[] exceptionClasses = candidate.getExceptionTypes();
            int l = exceptionClasses.length;
            String[] exceptionNames = new String[l];
            for (int i = 0; i < l; ++i) {
                exceptionNames[i] = exceptionClasses[i].getCanonicalName();
            }
            if ((candidate.getModifiers() & 8) != 0) {
                access = 8;
            }
            rule.setTypeInfo(targetClass.getName(), access, candidateName, candidateDesc, exceptionNames);
            int paramErrorCount = this.installParamTypes(rule, targetClass.getName(), access, candidateName, candidateDesc);
            if (paramErrorCount == 0) {
                try {
                    rule.typeCheck();
                }
                catch (TypeException te) {
                    System.out.println("TestScript : Failed to type check rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
                    ++this.typeErrorCount;
                    te.printStackTrace(System.out);
                    System.out.println();
                    return;
                }
                if (script.isInterface()) {
                    System.err.println("type checked interface rule \"" + script.getName() + "\" against method declaration");
                } else {
                    System.err.println("TestScript: type checked overriding rule \"" + script.getName() + "\" against method declaration");
                }
                System.err.println();
                continue;
            }
            this.errorCount += paramErrorCount;
            this.typeErrorCount += paramErrorCount;
            System.out.println("TestScript : Failed to type check rule \"" + script.getName() + "\" loaded from " + script.getFile() + " line " + script.getLine());
            System.err.println();
        }
    }

    static String makeDescriptor(Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        Class<?> retType = method.getReturnType();
        String desc = "(";
        for (Class<?> paramType : paramTypes) {
            String name = paramType.getCanonicalName();
            desc = desc + TypeHelper.externalizeType(name);
        }
        desc = desc + ")";
        desc = desc + TypeHelper.externalizeType(retType.getCanonicalName());
        return desc;
    }

    static String makeDescriptor(Constructor constructor) {
        Class<?>[] paramTypes = constructor.getParameterTypes();
        String desc = "(";
        for (Class<?> paramType : paramTypes) {
            String name = paramType.getCanonicalName();
            desc = desc + TypeHelper.externalizeType(name);
        }
        desc = desc + ")";
        return desc;
    }

    public int installParamTypes(Rule rule, String targetClassName, int access, String candidateName, String candidateDesc) {
        List<String> paramTypes = Type.parseMethodDescriptor(candidateDesc, false);
        int paramCount = paramTypes.size();
        int errorCount = 0;
        TypeGroup typegroup = rule.getTypeGroup();
        Bindings bindings = rule.getBindings();
        Iterator<Binding> iterator = bindings.iterator();
        while (iterator.hasNext()) {
            Binding binding = iterator.next();
            if (binding.getType() != Type.UNDEFINED) continue;
            if (binding.isRecipient()) {
                binding.setDescriptor(targetClassName);
                continue;
            }
            if (binding.isParam()) {
                int idx = binding.getIndex();
                if (idx > paramCount) {
                    ++errorCount;
                    System.err.println("TestScript: invalid method parameter reference $" + idx + " in rule \"" + rule.getName() + "\"");
                    continue;
                }
                binding.setDescriptor(paramTypes.get(idx - 1));
                continue;
            }
            if (!binding.isLocalVar()) continue;
            ++errorCount;
            System.err.println("TestScript: cannot typecheck local variable " + binding.getName() + " in rule \"" + rule.getName() + "\"");
        }
        return errorCount;
    }

    private TestScript(boolean verbose) {
        this.verbose = verbose;
    }
}

