#!/bin/sh

# =============================================================================
# RHQ Agent Byteman Helper Script
#
# Use this script to launch the RHQ Agent in a console with Byteman installed.
# This will install a set of Byteman rules into your agent to help perform
# runtime analysis of the agent.
#
# You tell this script where the RHQ Agent is installed via RHQ_AGENT_HOME.
# If RHQ_AGENT_HOME is not defined, it will assume the agent is in the current
# directory (and thus the agent launcher script at ./bin/rhq-agent.sh)
#
# You may define other environment variables to customize the RHQ Agent
# normally. However, do note that this script will add values to
# RHQ_AGENT_ADDITIONAL_JAVA_OPTS to install byteman in the agent VM.
# If your rhq-agent-env.sh also sets RHQ_AGENT_ADDITIONAL_JAVA_OPTS, those
# values will override what this script sets - therefore, if you set
# additional Java opts in rhq-agent-env.sh, add the _BYTEMAN_ARGS value
# to your rhq-agent-env.sh's definition of RHQ_AGENT_ADDITIONAL_JAVA_OPTS,
# like this:
#   RHQ_AGENT_ADDITIONAL_JAVA_OPTS="${_BYTEMAN_ARGS} ..your java opts here.."
#
# Any command line arguments passed to this script will be passed to the
# RHQ Agent launcher script.
# =============================================================================

_DOLLARZERO=`readlink "$0" 2>/dev/null || echo "$0"`
cd `dirname ${_DOLLARZERO}`
_SCRIPTDIR=`pwd`

_BYTEMAN_JAR="${_SCRIPTDIR}/byteman.jar"
_BYTEMAN_SCRIPT="script:${_SCRIPTDIR}/byteman-rules.txt"
_BYTEMAN_LISTENER="listener:${RHQ_AGENT_BYTEMAN_ENABLE:-false},port:${RHQ_AGENT_BYTEMAN_PORT:-9091},address:${RHQ_AGENT_BYTEMAN_HOST:-127.0.0.1}"
_BYTEMAN_ARGS="-javaagent:${_BYTEMAN_JAR}=${_BYTEMAN_SCRIPT},${_BYTEMAN_LISTENER}"
# export this in case the user needs to append them to his own additional opts in rhq-agent-env.sh
export _BYTEMAN_ARGS

if [ "x$RHQ_AGENT_ADDITIONAL_JAVA_OPTS" = "x" ]; then
   RHQ_AGENT_ADDITIONAL_JAVA_OPTS="${_BYTEMAN_ARGS}"
else
   RHQ_AGENT_ADDITIONAL_JAVA_OPTS="${RHQ_AGENT_ADDITIONAL_JAVA_OPTS} ${_BYTEMAN_ARGS}"
fi
export RHQ_AGENT_ADDITIONAL_JAVA_OPTS

_AGENT_SCRIPT=${RHQ_AGENT_HOME:-.}/bin/rhq-agent.sh
if [ ! -x "${_AGENT_SCRIPT}" ] ; then
   echo "Cannot find the rhq-agent.sh script: ${_AGENT_SCRIPT}"
   echo "Please set RHQ_AGENT_HOME to point to an agent installation directory"
   exit 1
fi

${_AGENT_SCRIPT} $*
