/*
 * JBoss, a division of Red Hat.
 * Copyright 2005-2008, Red Hat Middleware, LLC. All rights reserved.
 */


import java.util.Date;

import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementData;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.Resource;
import org.rhq.domain.correlation.ActionRule;
import org.rhq.domain.correlation.AvailabilityNormalizationRule;
import org.rhq.domain.correlation.CorrelationItem;
import org.rhq.domain.correlation.MetricNormalizationRule;
import org.rhq.domain.correlation.NormalizationOperator;
import org.rhq.domain.correlation.CorrelationRule;
import org.rhq.domain.correlation.ResultState;
import org.rhq.domain.correlation.MetricNormRuleItem;
import org.rhq.enterprise.server.correlation.CorrelationManagerBean;


/**
 * Example run through the correlation engine.
 * 
 * The following graph shows the correlation done in this test:
 * <p/>
 * <img src="../CorrelationTest.png"/>
 * 
 * @author Heiko W. Rupp
 */
public class Test1
{

   /**
    * @param args
    */
   public static void main(String[] args)
   {
      
      MeasurementScheduleRequest sched1 = new MeasurementScheduleRequest(1, "Schedule 1", 60000, true, DataType.MEASUREMENT);
      MeasurementScheduleRequest sched2 = new MeasurementScheduleRequest(2, "Schedule 2", 1 , true, DataType.TRAIT);
      
      MeasurementData data1 = new MeasurementDataNumeric(sched1, 1.0d);
      MeasurementData data2 = new MeasurementDataTrait(sched2, "Hello World");
      
      MetricNormalizationRule rule1 = new MetricNormalizationRule(1, "Rule1");
      MetricNormRuleItem item = new MetricNormRuleItem(ResultState.GREEN,NormalizationOperator.LESS_THEN, "3.0");
      rule1.addItem(item);
      item = new MetricNormRuleItem(ResultState.YELLOW,NormalizationOperator.IN_CLOSED,"3.0:10.0");
      rule1.addItem(item);
      item = new MetricNormRuleItem(ResultState.RED, NormalizationOperator.GREATER_THEN, "10.0");
      rule1.addItem(item);
      
      CorrelationManagerBean corrMgr = new CorrelationManagerBean();
      corrMgr.addMetricNormalizationRule(rule1);
      
      corrMgr.insertMetrics(data1); // should produce a result
      
      System.out.println("--- adding correlation rule ---");
      CorrelationRule crule = new CorrelationRule("Corr1", "Rule1");
      CorrelationItem citem = new CorrelationItem(ResultState.RED,2,0,0,0);
      crule.addItem(citem);
      citem = new CorrelationItem(ResultState.YELLOW,1,1,0,0);
      crule.addItem(citem);
      citem = new CorrelationItem(ResultState.YELLOW,0,2,0,0);
      crule.addItem(citem);
      citem = new CorrelationItem(ResultState.GREEN,0,1,1,0);
      crule.addItem(citem);
      citem = new CorrelationItem(ResultState.GREEN,0,0,2,0);
      crule.addItem(citem);
      crule.getSourceRules().add("No RHQ is bad");
      corrMgr.addCorrelationRule(crule);
      
      corrMgr.insertMetrics(data2); // should just return as we have no rule for schedule 2 yet
    
      crule = new CorrelationRule("Corr2","Rule1");
      citem = new CorrelationItem(ResultState.RED,1,0,0,0);
      crule.addItem(citem);
      citem = new CorrelationItem(ResultState.GREEN,0,1,0,0);
      crule.addItem(citem);
      citem = new CorrelationItem(ResultState.GREEN,0,0,1,0);
      crule.addItem(citem);
      corrMgr.addCorrelationRule(crule);
      
      data1 = new MeasurementDataNumeric(sched1, 5.5d);
      corrMgr.insertMetrics(data1);
      
      MetricNormalizationRule rule2 = new MetricNormalizationRule(2, "No RHQ is bad");
      item = new MetricNormRuleItem(ResultState.GREEN, NormalizationOperator.CONTAINS,"RHQ");
      rule2.addItem(item);
      item = new MetricNormRuleItem(ResultState.RED, NormalizationOperator.NOT_CONTAINS,"RHQ");
      rule2.addItem(item);
      corrMgr.addMetricNormalizationRule(rule2);
      System.out.println("-- added 2nd rule -");
      
      System.out.println("--- adding 2nd metric --- ");
      corrMgr.insertMetrics(data2);
      System.out.println("Correlation should have fired, -> should result in YELLOW");
      
      System.out.println("Adding availability normalization");
      AvailabilityNormalizationRule avrule1 = new AvailabilityNormalizationRule(1,"AvRule1",ResultState.GREEN,ResultState.YELLOW);
      corrMgr.addAvailabilityNormalizationRule(avrule1);


      System.out.println("Adding rule 'Total correlation' with sources 'Corr1' and 'AvRule1'");
      crule = new CorrelationRule("Total correlation", "Corr1");
      crule.getSourceRules().add("AvRule1");
      citem = new CorrelationItem(ResultState.RED,0,1,1,0);
      crule.addItem(citem);
      corrMgr.addCorrelationRule(crule);
      
      ActionRule ar = new ActionRule("My first action","Total correlation","PENG !");
      corrMgr.addCorrelationRule(ar);
      
      Resource res = new Resource(1);
      Availability av = new Availability(res,new Date(),AvailabilityType.UP);
      
      System.out.println("--- adding availability UP ---");
      corrMgr.insertAvailability(av);

      System.out.println("'Total correlation should have evaluated to 'RED'");
      System.out.println("'My first action' should have fired");
      
   }

}
