/*
 * JBoss, a division of Red Hat.
 * Copyright 2005-2008, Red Hat Middleware, LLC. All rights reserved.
 */

package org.rhq.domain.correlation;

import javax.persistence.Enumerated;
import javax.persistence.PrePersist;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

/**
 * An action that can be trigered my multiple sources
 * Persistence is an example at the moment
 *
 * @author Heiko W. Rupp
 */
@Table(name="RHQ_CORR_ARESULT")
@SequenceGenerator(name="RHQ_ACTION_RESULT_GEN", sequenceName="RHQ_CORR_ARESULT_SEQ")
public class ActionRule extends CorrelationRule
{
   String action;
   
   long ctime;
   
   @Enumerated
   ResultState state;
   
   public ActionRule(String actionName, String sourceRule, String action)
   {
      super(actionName, sourceRule);
      this.action = action;
   }

   public void trigger()
   {
      System.out.print("Action [" + ruleName + "] has been triggered: ");
      System.err.println(action);
   }

   public String getAction()
   {
      return action;
   }

   public void setAction(String action)
   {
      this.action = action;
   }

   public int getId()
   {
      return id;
   }

   public long getCtime()
   {
      return ctime;
   }

   public ResultState getState()
   {
      return state;
   }

   public void setState(ResultState state)
   {
      this.state = state;
   }
      
   @SuppressWarnings("unused")
   @PrePersist
   private void setCTime()
   {
      ctime = System.currentTimeMillis();
   }
}
