/*
 * JBoss, a division of Red Hat.
 * Copyright 2005-2008, Red Hat Middleware, LLC. All rights reserved.
 */

package org.rhq.domain.correlation;

import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

/**
 * One rule item for a {@link CorrelationRule}.
 *
 * @author Heiko W. Rupp
 */
@SequenceGenerator(name="RHQ_CORR_CITEM_GEN", sequenceName="RHQ_CORR_CITEM_SEQ")
@Table(name="RHQ_CORR_CITEM")
public class CorrelationItem
{
   @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="RHQ_CORR_CITEM_GEN")
   @Id
   int id;
   
   int red;
   int yellow;
   int green;
   int invalid;
   
   @Enumerated
   ResultState resultState;

   public CorrelationItem(ResultState resultState, int red, int yellow,
            int green, int invalid)
   {
      this.resultState = resultState;
      this.red = red;
      this.yellow = yellow;
      this.green = green;
      this.invalid = invalid;
   }

   public boolean matches(int reds, int yellows, int greens, int invalids) {
      return red == reds && yellow == yellows && green == greens && invalid == invalids;
   }
   
   public int getId()
   {
      return id;
   }

   public int getRed()
   {
      return red;
   }

   public int getYellow()
   {
      return yellow;
   }

   public int getGreen()
   {
      return green;
   }

   public int getInvalid()
   {
      return invalid;
   }

   public ResultState getResultState()
   {
      return resultState;
   }
   
   
}
