/*
 * JBoss, a division of Red Hat.
 * Copyright 2005-2007, Red Hat Middleware, LLC. All rights reserved.
 */

package org.rhq.domain.correlation;

import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

/**
 * One single expression of a metric normalization rule along with its result state.
 * This would e.g. contain "> 2.0" ==> YELLOW
 *
 * @author Heiko W. Rupp
 */
@SequenceGenerator(name="RHQ_CORR_MET_NORM_RULE_ITEM_GEN", sequenceName="RHQ_CORR_MET_N_I_SEQ")
@Table(name="RHQ_CORR_M_NORM_RULE_I")
public class MetricNormRuleItem
{
   @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="RHQ_CORR_MET_NORM_RULE_ITEM_GEN")
   @Id
   int id;
   
   @Enumerated
   NormalizationOperator operator;
   
   String value;
   
   @Enumerated
   ResultState resultState;
   
   /**
    * Create a new RuleItem.
    * @param resultState What {@link ResultState} should be returned, if the item matches?
    * @param operator The operator to compare values
    * @param value the reference value
    */
   public MetricNormRuleItem(ResultState resultState, NormalizationOperator operator, String value )
   {
      this.value = value;
      this.resultState = resultState;
      this.operator = operator;
   }

   /**
    * Returns the reference value
    * @return reference value stored in the rule
    */
   public String getValue()
   {
      return value;
   }

   /**
    * Returns the {@link ResultState}
    * @return resultState for this rule
    */
   public ResultState getResultState()
   {
      return resultState;
   }

   /**
    * Returns the {@link NormalizationOperator} used to compare
    * @return the comparision operator
    */
   public NormalizationOperator getOperator()
   {
      return operator;
   }

   /** Technical primary key */
   public int getId()
   {
      return id;
   }
}
