/*
 * JBoss, a division of Red Hat.
 * Copyright 2005-2008, Red Hat Middleware, LLC. All rights reserved.
 */

package org.rhq.domain.correlation;

import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.operation.OperationResult;

/**
 * Comparator operator for RuleItems
 *
 * @author Heiko W. Rupp
 */
public enum NormalizationOperator
{
      // Numerical ones
      /** <   (for numeric metrics)*/
     LESS_THEN,
     /** >=   (for numeric metrics)*/
     LESS_EQUALS,
     /** ==   (for numeric metrics)*/
     EQUALS,
     /** =>   (for numeric metrics)*/
     GREATER_EQUALS,
     /** >   (for numeric metrics)*/
     GREATER_THEN,
     /** !=   (for numeric metrics)*/
     NOT_EQUALS,
     /** Usage: IN_CLOSED a:b  same as ( a <= value <=b )   (for numeric metrics)*/
     IN_CLOSED,  
     /** IN_OPEN a:b same as (a < value < b)   (for numeric metrics)*/
     IN_OPEN, 
     /** OUTSIDE a:b  same as (value <a || value > b)   (for numeric metrics)*/
     OUTSIDE, 
     /** isNan()   (for numeric metrics)*/
     IS_NAN,
     // String ones
     /** contains(reference)  (for trait metrics)*/
     CONTAINS,
     /** !contains(reference)  (for trait metrics)*/
     NOT_CONTAINS,
     /** matches(reference regexp  (for trait metrics)*/
     MATCHES,
     /** !matches(reference regexp  (for trait metrics)*/
     NOT_MATCHES,
     /** startsWith(reference)  (for trait metrics)*/
     STARTS_WITH,
     /** endsWith(reference)  (for trait metrics)*/
     ENDS_WITH, 
     // Availability
     /** value == {@link AvailabilityType}.UP  */
     IS_UP,
     /** value == {@link AvailabilityType}.DOWN */
     IS_DOWN,
     // Operations
     /** {@link OperationResult}.isSuccess() == TRUE  */
     SUCCESS,
     /** {@link OperationResult}.isSuccess() == FALSE  */
     FAILURE
     ;
}
