/*
 * JBoss, a division of Red Hat.
 * Copyright 2005-2008, Red Hat Middleware, LLC. All rights reserved.
 */
package org.rhq.domain.correlation;

import javax.persistence.DiscriminatorColumn;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

/**
 * This is the base class for rules of the normalization part of correlation.
 * T denotes the kind of input a subclass expects
 * @author Heiko W. Rupp
 */
@SequenceGenerator(name="RHQ_NORM_RULE_GEN", sequenceName="RHQ_CORR_NRULE_SEQ")
@Table(name="RHQ_CORR_NRULE")
@DiscriminatorColumn(name="DISC")
public abstract class NormalizationRule<T>
{

   @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="RHQ_NORM_RULE_GEN")
   @Id
   int id;
   /** Name of the rule */
   String ruleName;

   /**
    * This method does the normalization of the input
    * @param arg Input data to normalize
    * @return a {@link ResultState} from this normalization.
    */
   public abstract ResultState normalize(T arg);

   /**
    * Return the name of this rule
    * @return name of this rule
    */
   public String getRuleName()
   {
      return ruleName;
   }

   /** Technical primary key */
   public int getId()
   {
      return id;
   }
}
