/*
 * JBoss, a division of Red Hat.
 * Copyright 2005-2007, Red Hat Middleware, LLC. All rights reserved.
 */

package org.rhq.domain.correlation;

/**
 * A normalized data item flowing through the correlation system.
 * It consists of the name of the rule this is coming from and the 
 * state the last rule computed.
 * 
 * Sources rules can be {@link NormalizationRule}s as well as {@link CorrelationRule}s.
 *
 * @author Heiko W. Rupp
 */
public class NormalizedData implements Cloneable
{
   ResultState state;
   String sourceRule; 
   
   /**
    * Create a new object
    * @param sourceRule The name of the source rule
    * @param resultState The state computed by the source rule
    */
   public NormalizedData(String sourceRule, ResultState resultState)
   {
      this.state = resultState;
      this.sourceRule = sourceRule;
   }

   public ResultState getState()
   {
      return state;
   }

   public String getSourceRule()
   {
      return sourceRule;
   }




   public int hashCode()
   {
      final int prime = 31;
      int result = 1;
      result = prime * result
               + ((sourceRule == null) ? 0 : sourceRule.hashCode());
      return result;
   }




   public boolean equals(Object obj) // TODO use the state too ?
   {
      if (this == obj)
         return true;
      if (obj == null)
         return false;
      if (!(obj instanceof NormalizedData))
         return false;
      final NormalizedData other = (NormalizedData) obj;
      if (sourceRule == null)
      {
         if (other.sourceRule != null)
            return false;
      }
      else if (!sourceRule.equals(other.sourceRule))
         return false;
      return true;
   }




   protected Object clone() throws CloneNotSupportedException
   {
      // TODO Auto-generated method stub
      return super.clone();
   }
   
}
