/*
 * JBoss, a division of Red Hat.
 * Copyright 2005-2008, Red Hat Middleware, LLC. All rights reserved.
 */

package org.rhq.domain.correlation;


import javax.persistence.DiscriminatorValue;

import org.rhq.core.pluginapi.operation.OperationResult;

/**
 * Normalizations for Operation results
 *
 * @author Heiko W. Rupp
 */
@DiscriminatorValue("OPER")
public class OperationsNormalizationRule extends NormalizationRule<OperationResult>
{

   int operationDefinitionId;
   ResultState stateOnSucess;
   ResultState stateOnFailue;
   
   public OperationsNormalizationRule(int operationDefinitionId, String ruleName,
            ResultState stateOnSucess, ResultState stateOnFailue)
   {
      this.ruleName = ruleName;
      this.operationDefinitionId = operationDefinitionId;
      this.stateOnSucess = stateOnSucess;
      this.stateOnFailue = stateOnFailue;
   }

   public ResultState normalize(OperationResult result) {

      return stateOnSucess; // TODO provide a real implementation
      
   }
   
   public int getOperationDefinitionId()
   {
      return operationDefinitionId;
   }

   public ResultState getStateOnSucess()
   {
      return stateOnSucess;
   }

   public ResultState getStateOnFailue()
   {
      return stateOnFailue;
   }
   
   
}
