@echo off

set __rhq_to_use=trunk

rem Setup Java
call C:\mazz\setup\java5-setup.bat
rem call C:\mazz\setup\java6-setup.bat
set RHQ_AGENT_JAVA_HOME=%JAVA_HOME%

rem Setup Maven
call C:\mazz\setup\maven-setup.bat

rem Setup ANT
call C:\mazz\setup\ant-setup.bat

rem Setup SVN
call C:\mazz\setup\svn-setup.bat

rem Determine the RHQ install to use
if "%__rhq_to_use%"=="trunk" (
   set _RHQ_DOT_VERSION=1.2.0-SNAPSHOT
   set _RHQ_VERSION=1_2_0-SNAPSHOT
   set _RHQ_PROJECT_NAME=rhq\trunk
) else if "%__rhq_to_use%"=="1.0.0.GA" (
   set _RHQ_DOT_VERSION=1.0.0.GA
   set _RHQ_VERSION=1_0_0_GA
   set _RHQ_PROJECT_NAME=rhq\tags\RHQ_1_0_0_GA
) else if "%__rhq_to_use%"=="1.0.1.GA" (
   set _RHQ_DOT_VERSION=1.0.1.GA
   set _RHQ_VERSION=1_0_1_GA
   set _RHQ_PROJECT_NAME=rhq\tags\RHQ_1_0_1_GA
) else if "%__rhq_to_use%"=="1.1.0.GA" (
   set _RHQ_DOT_VERSION=1.1.0.GA
   set _RHQ_VERSION=1_1_0_GA
   set _RHQ_PROJECT_NAME=rhq\tags\RHQ_1_1_0_GA
) else (
   echo "UNKNOWN RHQ VERSION!"
   pause
   exit 127
)

rem All source code is stored under a main source code root directory
set _RHQ_ROOT=C:\mazz\source\%_RHQ_PROJECT_NAME%
set _CWD=%~dp0

echo Using RHQ "%__rhq_to_use%" located at "%_RHQ_ROOT%"
