/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.finder;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.finder.filters.PathFilter;
import org.apache.commons.finder.filters.RegexFilter;
import org.apache.commons.finder.filters.SizeFilter;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class FindingFilter
extends AndFileFilter {
    private static final long MINUTE = 60000L;
    private static final long DAY = 86400000L;
    private boolean daystart;

    public FindingFilter(Map options) {
        this.daystart = options.containsKey("DAYSTART");
        Set entries = options.entrySet();
        Iterator itr = entries.iterator();
        while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            if (entry.getKey().equals("DAYSTART")) continue;
            Object key = entry.getKey();
            if (key instanceof IOFileFilter) {
                this.addFileFilter((IOFileFilter)key);
                continue;
            }
            IOFileFilter filter = this.createFilter(key.toString(), entry.getValue());
            if (filter == null) continue;
            this.addFileFilter(filter);
        }
    }

    private IOFileFilter createFilter(String option, Object argument) {
        if (argument instanceof IOFileFilter) {
            return (IOFileFilter)argument;
        }
        boolean invert = false;
        if (option.startsWith("NOT_")) {
            invert = true;
            option = option.substring("NOT_".length());
        }
        if (option.equals("MIN")) {
            int minutes = this.toInt(argument);
            return new AgeFileFilter((long)minutes * 60000L, invert);
        }
        if (option.equals("NEWER")) {
            File refFile = argument instanceof File ? (File)argument : new File(argument.toString());
            return new AgeFileFilter(refFile, invert);
        }
        if (option.equals("TIME")) {
            int days = this.toInt(argument);
            return new AgeFileFilter((long)days * 86400000L, invert);
        }
        if (option.equals("SIZE")) {
            SizeFilter filter = new SizeFilter(argument.toString());
            return invert ? new NotFileFilter((IOFileFilter)filter) : filter;
        }
        if (option.equals("NAME")) {
            WildcardFileFilter filter = new WildcardFileFilter(argument.toString(), IOCase.SENSITIVE);
            return invert ? new NotFileFilter((IOFileFilter)filter) : filter;
        }
        if (option.equals("INAME")) {
            WildcardFileFilter filter = new WildcardFileFilter(argument.toString(), IOCase.INSENSITIVE);
            return invert ? new NotFileFilter((IOFileFilter)filter) : filter;
        }
        if (option.equals("PATH")) {
            PathFilter filter = new PathFilter(argument.toString(), false);
            return invert ? new NotFileFilter((IOFileFilter)filter) : filter;
        }
        if (option.equals("IPATH")) {
            PathFilter filter = new PathFilter(argument.toString(), true);
            return invert ? new NotFileFilter((IOFileFilter)filter) : filter;
        }
        if (option.equals("REGEX")) {
            RegexFilter filter = new RegexFilter(argument.toString(), false);
            return invert ? new NotFileFilter((IOFileFilter)filter) : filter;
        }
        if (option.equals("IREGEX")) {
            RegexFilter filter = new RegexFilter(argument.toString(), true);
            return invert ? new NotFileFilter((IOFileFilter)filter) : filter;
        }
        return null;
    }

    public boolean isDaystartConfigured() {
        return this.daystart;
    }

    private int toInt(Object argument) {
        if (argument instanceof Number) {
            return ((Number)argument).intValue();
        }
        try {
            return Integer.parseInt(argument.toString());
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Argument " + argument + " must be an integer.");
        }
    }
}

