/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.finder.filters;

import java.io.File;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class SizeFilter
extends AbstractFileFilter {
    private long size;
    private long factor = 1L;
    private char comparator = (char)61;
    private boolean roundUp = true;
    private String origSize;

    public SizeFilter(String size) {
        this(size, true);
    }

    public SizeFilter(String size, boolean roundUp) {
        String parseSize;
        this.roundUp = roundUp;
        this.origSize = this.origSize;
        String string = parseSize = size == null ? "" : size.trim();
        if (parseSize.length() > 0) {
            if (parseSize.charAt(0) == '+') {
                this.comparator = (char)62;
                parseSize = parseSize.substring(1);
            } else if (parseSize.charAt(0) == '-') {
                this.comparator = (char)60;
                parseSize = parseSize.substring(1);
            }
        }
        if (parseSize.length() > 0) {
            int lastIdx = parseSize.length() - 1;
            char lastChar = parseSize.charAt(lastIdx);
            char c = lastChar = Character.isLetter(lastChar) ? Character.toLowerCase(lastChar) : lastChar;
            if (lastChar == 'k') {
                this.factor = 1024L;
            } else if (lastChar == 'm') {
                this.factor = 0x100000L;
            } else if (lastChar == 'g') {
                this.factor = 0x40000000L;
            }
            if (this.factor > 1L) {
                parseSize = parseSize.substring(0, lastIdx);
            }
        }
        try {
            this.size = Long.parseLong(parseSize) * this.factor;
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Argument " + size + " must be an integer.");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append(", size ");
        buffer.append(this.comparator);
        buffer.append(" ");
        buffer.append(this.origSize);
        if (this.comparator == '=' && this.factor > 1L) {
            buffer.append(", roundUp=");
            buffer.append(this.roundUp);
        }
        return buffer.toString();
    }

    public boolean accept(File file) {
        long fileSize = file.length();
        switch (this.comparator) {
            case '>': {
                return fileSize > this.size;
            }
            case '<': {
                return fileSize < this.size;
            }
        }
        if (this.roundUp) {
            return fileSize > this.size - this.factor && fileSize <= this.size;
        }
        return fileSize >= this.size && fileSize < this.size + this.factor;
    }
}

