/**
 * Copyright 2010 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jbpm.process.workitem.twitter;

import java.util.Properties;

import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;

import twitter4j.Twitter;
import twitter4j.TwitterFactory;
import twitter4j.conf.ConfigurationBuilder;

public class TwitterWorkItemHandler implements WorkItemHandler {

	private Twitter twitter;
    
    public void setCredentials(String consumerKey, String consumerSecret, String accessKey, String accessSecret) {
        ConfigurationBuilder configBuilder = new ConfigurationBuilder();
        configBuilder
        	.setDebugEnabled(true)
        	.setOAuthConsumerKey(consumerKey)
        	.setOAuthConsumerSecret(consumerSecret)
        	.setOAuthAccessToken(accessKey)
        	.setOAuthAccessTokenSecret(accessSecret);
        twitter = new TwitterFactory(configBuilder.build()).getInstance();
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        try {
            if (twitter == null) {
                initTwitter();
            }
            String message = (String)workItem.getParameter("Message");
            if (message != null && message.trim().length() > 0) {
                twitter.updateStatus(message);
            }
        }
        catch(Throwable t) {
            t.printStackTrace();
            manager.abortWorkItem(workItem.getId());
        }
        manager.completeWorkItem(workItem.getId(), null);
    }

    private void initTwitter() throws Exception {
        Properties p = new Properties();
        p.load(TwitterWorkItemHandler.class.getResourceAsStream("/twitter.properties"));
        setCredentials(
    		p.getProperty("twitter.consumerKey"), 
    		p.getProperty("twitter.consumerSecret"), 
    		p.getProperty("twitter.accessKey"), 
    		p.getProperty("twitter.accessSecret"));
    }

    public void abortWorkItem(WorkItem workitem, WorkItemManager workitemmanager) {
    }
}
